#!/bin/sh
#

RA_PFX=xml/ra-
RA_XML=xml/hb_agentlist_details.xml

xml_header() {
cat <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE appendix PUBLIC "-//OASIS//DTD DocBook XML V4.4//EN" "docbookx.dtd" 
[  
<!ENTITY % entities SYSTEM "entity-decl.ent"> 
%entities; ]>
<!--
*********************************
Please see LICENSE.txt for this document's license.
*********************************
-->
<appendix xml:base="hb_agentlist_details.xml" id="app.agents.details">
 <title>HB OCF Agents</title>
 
 <para>
  All OCF agents require several parameters to be set when they
  are started. The following overview shows how to manually operate
  these agents. The data that is available in this appendix is
  directly taken from the <literal>meta-data</literal> invocation of
  the respective RA. Find all these agents in 
  <filename>/usr/lib/ocf/resource.d/heartbeat/</filename>.
 </para>
 <para>
  When configuring an RA, omit the
  <literal>OCF_RESKEY_</literal> prefix to the parameter name.
  Parameters that are in square brackets may be omitted in the
  configuration.
 </para>
EOF
}
xml_footer() {
cat <<EOF
</appendix>
EOF
}
xml_include() {
	echo "<xi:include xmlns:xi=\"http://www.w3.org/2001/XInclude\" href=\"$1\"/>"
}
metadata2xml() {
	$1 meta-data | xsltproc --nonet --novalid ocfra2refentry.xsl -
}

: ${OCF_ROOT:=/usr/lib/ocf}
[ -d "$OCF_ROOT" ] || {
	echo No $OCF_ROOT OCF resource agents directory >&2
	exit 1
}
export OCF_ROOT

(
xml_header
for f in $OCF_ROOT/resource.d/heartbeat/*; do
	[ -x "$f" ] || continue
	xml=$RA_PFX`basename $f`.xml
	metadata2xml $f > $xml
	if xmllint --noout $xml; then
		xml_include `basename $xml`
	else # skip this ra if xml fails to validate
		rm $xml
	fi
done
xml_footer
) > $RA_XML
