//////////////////////////////////////////////////////////////////////////////
// check.h

#ifndef CHECK_H
#define CHECK_H

// Mode to be used for "inner" model checking run, i.e. the program
// that was simplified using the R operator and modularity results.
enum MCM_MODE {
    MCM_THROWASSERTION = 0,   // only to be used for HCF programs
    MCM_USEMODELGENERATOR,    // uses the model generator for finding an ufs
    MCM_CALLDAVISPUTNAM
    };

// Check the stability of interpretation w.r.t. component component_index of
// depgraph.
bool IsComponentStable(
    DEPGRAPH<GATOM,GCONSTRAINTS,GPROGRAM> *depgraph,
    const GINTERPRET &interpretation,
    const GATOMSET   &positiveAssumptions,
    const unsigned    component_index,
    const MCM_MODE    nonhcf_mode );

// Check the stability of (partial) model interpretation w.r.t. GroundIDB.
// If knownHCF is true, depgraph may be NULL, otherwise it must point to a
// valid ground dependency graph.
bool IsStable(
   const GINTERPRET &interpretation,
   const GRULES     &GroundIDB,
   const bool        knownHCF,
         DEPGRAPH<GATOM,GCONSTRAINTS,GPROGRAM> *depgraph,
   const GATOMSET &,
         GATOMSET *,
         bool * );

bool IsUnfoundedSet(
    const GATOMSET &,
    const GINTERPRET &,
    const GRULES &,
          vector<const GRULE*> *);

bool IsUnfoundedSet(
    const GATOMSET &,
    const GINTERPRET &,
    const vector<const GRULE*> &);
#endif
