///////////////////////////////////////////////////////////////////////////////
// indent.h 

#ifndef INDENT_H
#define INDENT_H

#include <iomanip>                                            // for << setw()

// The only purpose of this class is overloading operator << such that
//   ostream << indent(unsigned n)
// will print n blanks.

class indent                     
    {
    unsigned x;

public:
    indent(unsigned init)
        {
        x=init;
        }
 
    unsigned get() const
        {
        return x;
        }
    };   
 
inline ostream& operator<< (ostream& out, const indent& amount)
    {
    if( amount.get() > 0 )
        out << setw(amount.get()) << " ";

    return out;
    }

#endif
