#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="boost-summary.txt"

echo "# DATE wave-build wave-size wave-run wave-mem" > $summary

for i in $LOGDIR/boost-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  grep '^TIME:' $i | sed -e 's/^TIME: \([0-9.]*\)/\1/g' | tr '\n' ' ' | cat >> $summary
  grep '^FILESIZE:' $i | cut -d ' ' -f 8 | tr '\n' ' ' | cat >> $summary
  grep '^Elapsed time:' $i | cut -d ' ' -f 3 | tr '\n' ' ' | cat >> $summary
  grep '^total:' $i | cut -d ' ' -f 2 | tr '\n' ' ' | cat >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/boost-summary.gp-`hostname`; then
  gnuplot $BASEDIR/boost-summary.gp-`hostname`
else
  gnuplot $BASEDIR/boost-summary.gp
fi
