#!/bin/sh

# Usage: libstdc++-performance.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

cd $TMPDIR
rm -Rf tmp
mkdir tmp
cd tmp
$BASEDIR/check_performance $BASEDIR $GCCINSTALLDIR

LOGFILE="$LOGDIR/libstdc++-performance-`date +%y%m%d-%s`"
echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE
date 2>&1 | tee -a $LOGFILE
cat libstdc++-performance.sum 2>&1 | tee -a $LOGFILE
date 2>&1 | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/libstdc++-performance-latest
