#!/bin/sh

# on "modern" hosts such as ia64 tracking mmap is enough,
# old hosts may use both old_mmap and mmap2
# strace barfs on unknown syscalls, so we need to check
syscalls="brk,munmap"
for sysmmap in mmap mmap2 old_mmap; do
  if strace -e $sysmmap /bin/true >/dev/null 2>&1; then
    syscalls="$syscalls,$sysmmap"
  fi
done

# now try to figure out where the maxmem-pipe2.py script is located
MAXMEMPIPE="`dirname $0`/maxmem-pipe2.py"

strace -o "|$MAXMEMPIPE" -e $syscalls -f $@

