//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FieldExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef FIELD_EXPRESSION_HPP
#define FIELD_EXPRESSION_HPP

#include <Expression.hpp>

#include <ReferenceCounting.hpp>
#include <FunctionExpression.hpp>

/**
 * @file   FieldExpression.hpp
 * @author Stephane Del Pino
 * @date   Sun Feb  9 16:41:04 2003
 * 
 * @brief  Describes functions fields
 * 
 * \warning only fields with 3 component are now supported
 */

class FieldExpression
  : public Expression
{
private:
  ReferenceCounting<FunctionExpression> __f1; /**< First  component of the field */
  ReferenceCounting<FunctionExpression> __f2; /**< Second component of the field */
  ReferenceCounting<FunctionExpression> __f3; /**< Third  component of the field */

  std::ostream& put(std::ostream& os) const;

public:
  FunctionExpression& f1()
  {
    return *__f1;
  }

  FunctionExpression& f2()
  {
    return *__f2;
  }

  FunctionExpression& f3()
  {
    return *__f3;
  }

  void execute();

  FieldExpression(ReferenceCounting<FunctionExpression> f1,
		  ReferenceCounting<FunctionExpression> f2,
		  ReferenceCounting<FunctionExpression> f3);

  FieldExpression(const FieldExpression& F);

  ~FieldExpression();
};

#endif // FIELD_EXPRESSION_HPP
