//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FieldExpression.cpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#include <FieldExpression.hpp>

std::ostream&  FieldExpression::
put(std::ostream& os) const
{
  os << '[' << (*__f1) << ','  << (*__f2) << ','  << (*__f3) << ']' ;
  return os;
}


void FieldExpression::
execute()
{
  (*__f1).execute();
  (*__f2).execute();
  (*__f3).execute();
}

FieldExpression::
FieldExpression(ReferenceCounting<FunctionExpression> f1,
		ReferenceCounting<FunctionExpression> f2,
		ReferenceCounting<FunctionExpression> f3)
  : Expression(Expression::field),
    __f1(f1),
    __f2(f2),
    __f3(f3)
{
  ;
}

FieldExpression::
FieldExpression(const FieldExpression& F)
  : Expression(F),
    __f1(F.__f1),
    __f2(F.__f2),
    __f3(F.__f3)
{
  ;
}

FieldExpression::
~FieldExpression()
{
  ;
}
