//////////////////////////////////////////////////////////////////////////////
// builtin.h

#ifndef BUILTIN_H
#define BUILTIN_H

// the built-ins we recognize
enum BUILTIN {
    BuiltinEquality, BuiltinInequality,
    BuiltinLess, BuiltinGreater,
    BuiltinLessEqual, BuiltinGreaterEqual,
    NSimpleBuiltins,		// This marks the end of the simple built-ins.
    BuiltinInt=NSimpleBuiltins,	// (without the = we would lose one step)
    BuiltinSucc,
    BuiltinAddition, BuiltinMultiplication,
    NBuiltins			// This must be last, so that it is exactly
				// equal the number of built-in predicates.
};

#define MaxBuiltinArity 3	// we have unary, binary, and ternary built-ins

extern const char *builtin_name[];
extern unsigned builtin_arity[];

#ifdef BUILTIN_IMPL

// printable names of the abovementioned built-ins - must be kept in the same
// order
const char *builtin_name[]={
    "==", "!=",
    "<",  ">",
    "<=", ">=",

    "#int",
    "#succ",
    "+",  "*"
};

// arities of the built-ins, this too has to be ordered like the enum BUILTIN
unsigned builtin_arity[]={
    2, 2,
    2, 2,
    2, 2,

    1,
    2,
    3, 3
};

#endif

#endif

// Local Variables:
// mode: c++
// c-file-style: "dl"
// End:
