%{
/////////////////////////////////////////////////////////////////////////////
// diag_scanner.l

#include "diag_parser.h"

 // We don't need unput, and it can yield a "defined but not used"-warning.
#define YY_NO_UNPUT
%}

BLANK       ([ \t]+)
NEWLINE     \15?\n
                         // some OSs use \r\n as end-of-line instead of \n

ID          ([A-Za-z][A-Za-z_0-9]{0,19}) 
                     //             ^^                       
                     // maximum ID length - 1 (appears numerically in dl.h) 
STRANGE_ID  ([0-9]+_[0-9]+)
QUOTED_ID   (\"[^\"]+\")

NUM         ([0-9]+)


%%


{NEWLINE}              { 
                         parser_line++;        
                       }

 
\,                     { return COMMA;          }
\.                     { return DOT;            }

\(                     { return PARAM_OPEN;     }
\)                     { return PARAM_CLOSE;    } 

\[                     { return BRACKET_OPEN;   }
\]                     { return BRACKET_CLOSE;  }

[Nn][Oo][Tt]           |
[Nn][Oo][Nn]           { return NOT;            }

{ID}                   { 
			 diagyylval.string=new char[strlen(yytext)+1];
                         strcpy(diagyylval.string,yytext);
                         return ID;
                       }

{QUOTED_ID}	       |
{STRANGE_ID}           { 
			 unsigned len=strlen(yytext);

			 if( len > IDENT_LENGTH )
			     {
			     len=IDENT_LENGTH;

			     diagyyerror("identifier too long, truncated");
			     }

			 diagyylval.string=new char[len+1];
			 strncpy(diagyylval.string,yytext,len);
			 diagyylval.string[len]=0;

			 return ID;
                       }

{NUM}			{ 
  			  if( strlen(diagyytext) > NUM_LENGTH )
  			      {
  			      char s[1024];
 			      sprintf( s,
 			               "numeric constant %s is too long",
 			               diagyytext );
  			      diagyyerror(s);
 
                              parser_errors++; 
 			      return ERROR;
  			      }
  			  else
  			      {
			      diagyylval.string=new char[strlen(yytext)+1];
			      strcpy(diagyylval.string,yytext);
			      }

			  return NUM; 
			}


\%.*                   { // Skip comments 
                       }
{BLANK}                { // Skip blanks   
                       }


.                      { // Anything not matching one of the patterns
                         // given above is considered an error.
                         char s[1024];

			 assert(yytext[1]==0);
                         sprintf(s,"syntax error (%s)",yytext); 
                         diagyyerror(s);
                       }
