set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

set output "boost-summary-build.png"
set ylabel "time [s]"
set title "boost wave build time"
plot [:] [:] \
	"boost-summary.txt" u 1:2 title "mainline" w lp
set output

set output "boost-summary-size.png"
set ylabel "size [bytes]"
set title "boost wave text size"
plot [:] [:] \
	"boost-summary.txt" u 1:3 title "mainline" w lp
set output

set output "boost-summary-run.png"
set ylabel "time [s]"
set title "boost wave run time preprocessing tramp3d-v4.cpp"
plot [:] [:] \
	"boost-summary.txt" u 1:4 title "mainline" w lp
set output

set output "boost-summary-mem.png"
set ylabel "size [kB]"
set title "boost wave memory usage preprocessing tramp3d-v4.cpp"
plot [:] [:] \
	"boost-summary.txt" u 1:5 title "mainline" w lp
set output

