#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="botan-summary.txt"

echo -n "# DATE build-time build-memory text-size " > $summary
for i in `cat $BASEDIR/tests`; do
  echo -n $i >> $summary
done
echo >> $summary

for i in $LOGDIR/botan-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  ( grep '^TIME:' $i || echo "TIME: 0" ) | sed -e 's/^TIME: \(.*\)$/\1/g' | tr '\n' ' ' | cat >> $summary
  ( grep '^total:' $i || echo "total: 0 kB" ) | sed -e 's/^total: \(.*\) kB$/\1/g' | tr '\n' ' ' | cat >> $summary
  ( grep '^FILESIZE:' $i || echo "FILESIZE: a a a a a a 0" ) | cut -d ' ' -f 8 | tr '\n' ' ' | cat >> $summary
  cat $i | sed -e '/Mbytes\/sec$/!d' | tr -s ' ' | cut -d ' ' -f 2 | tr '\n' ' ' >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/botan-summary.gp-`hostname`; then
  gnuplot $BASEDIR/botan-summary.gp-`hostname`
else
  gnuplot $BASEDIR/botan-summary.gp
fi
