#!/bin/sh

# Usage: botan.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/botan-performance-`date +%y%m%d-%s`"

export PATH=$GCCINSTALLDIR/bin:$PATH
export LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH

cd $TMPDIR

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

# build
date 2>&1 | tee -a $LOGFILE
rm -Rf Botan-1.5.5
tar xzf $BASEDIR/Botan-1.5.5.tgz
cd Botan-1.5.5
patch -p0 < $BASEDIR/Botan-1.5.5.patch
./configure.pl --noauto --modules=tm_unix gcc-generic-generic
/usr/bin/time -f "TIME: %U" $BASEDIR/../maxmem2.sh make 2>&1 | tee -a $LOGFILE
make check
echo FILESIZE: `size ./check` 2>&1 | tee -a $LOGFILE
date 2>&1 | tee -a $LOGFILE

# run
LD_LIBRARY_PATH=.:$LD_LIBRARY_PATH ./check --benchmark 2>&1 | tee -a $LOGFILE
date 2>&1 | tee -a $LOGFILE

cp $LOGFILE $LOGDIR/botan-performance-latest
