set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

set output "freefem-compile.png"
set title "Compile time for the ff3d binary in s"
set ylabel "s"
plot [:] [:] "freefem-summary.txt"  u 1:2 title "mainline" w lp
set output "freefem-memory.png"
set title "Compile time memory usage for building ff3d in kB"
set ylabel "kB"
plot [:] [:] "freefem-summary.txt"  u 1:3 title "mainline" w lp
set output "freefem-textsize.png"
set title "Text size of the ff3d binary in bytes"
set ylabel "bytes"
plot [:] [:] "freefem-summary.txt"  u 1:4 title "mainline" w lp


# ../gen-gp.sh --skip 3 --title Benchmark runtime in s --ylabel s freefem-summary.txt tests 1 1
set ylabel "s"

set logscale y
set output "freefem-summary.txt-1-0.png"
set title "Benchmark runtime in s"
plot [:] [:] "freefem-summary.txt"  u 1:5 title "elasticity.ff" w lp, \
	"" u 1:6 title "hydrostatic.ff" w lp, \
	"" u 1:7 title "natural-convection.ff" w lp, \
	"" u 1:8 title "navier-stokes.ff" w lp, \
	"" u 1:9 title "potential-fluid-flow.ff" w lp, \
	"" u 1:10 title "stokes.ff" w lp, \
	"" u 1:11 title "temperature.ff" w lp, \
	"" u 1:12 title "test.ff" w lp
set nologscale

set output "freefem-summary.txt-elasticity.ff-5.png"
set title "Benchmark runtime in s for elasticity.ff"
plot [:] [:] "freefem-summary.txt" u 1:5 title "elasticity.ff" w lp
set output "freefem-summary.txt-hydrostatic.ff-6.png"
set title "Benchmark runtime in s for hydrostatic.ff"
plot [:] [:] "freefem-summary.txt" u 1:6 title "hydrostatic.ff" w lp
set output "freefem-summary.txt-natural-convection.ff-7.png"
set title "Benchmark runtime in s for natural-convection.ff"
plot [:] [:] "freefem-summary.txt" u 1:7 title "natural-convection.ff" w lp
set output "freefem-summary.txt-navier-stokes.ff-8.png"
set title "Benchmark runtime in s for navier-stokes.ff"
plot [:] [:] "freefem-summary.txt" u 1:8 title "navier-stokes.ff" w lp
set output "freefem-summary.txt-potential-fluid-flow.ff-9.png"
set title "Benchmark runtime in s for potential-fluid-flow.ff"
plot [:] [:] "freefem-summary.txt" u 1:9 title "potential-fluid-flow.ff" w lp
set output "freefem-summary.txt-stokes.ff-10.png"
set title "Benchmark runtime in s for stokes.ff"
plot [:] [:] "freefem-summary.txt" u 1:10 title "stokes.ff" w lp
set output "freefem-summary.txt-temperature.ff-11.png"
set title "Benchmark runtime in s for temperature.ff"
plot [:] [:] "freefem-summary.txt" u 1:11 title "temperature.ff" w lp
set output "freefem-summary.txt-test.ff-12.png"
set title "Benchmark runtime in s for test.ff"
plot [:] [:] "freefem-summary.txt" u 1:12 title "test.ff" w lp
set output

