#!/bin/sh

# Usage: freefem.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/freefem-performance-`date +%y%m%d-%s`"

cd $TMPDIR

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

export PATH=$GCCINSTALLDIR/bin:$PATH
export LD_LIBRARY_PATH=$GCCINSTALLDIR/lib64:$GCCINSTALLDIR/lib:$LD_LIBRARY_PATH

rm -Rf ff3d
tar xzf $BASEDIR/ff3d.tar.gz
( cd ff3d
# using dynamic_cast causes bad_cast exceptions to be thrown everywhere
CXXFLAGS="-O2 -DNDEBUG -Ddynamic_cast=static_cast" CFLAGS="-O2 -DNDEBUG" ./configure --disable-pthread
/usr/bin/time -f "TIME: %U" $BASEDIR/../maxmem2.sh make 2>&1 | tee -a $LOGFILE
echo FILESIZE: `size ./ff3d` 2>&1 | tee -a $LOGFILE
make check 2>&1 | tee -a $LOGFILE
cd examples
for i in `cat $BASEDIR/tests`; do
  /usr/bin/time -f "TIME: %U $i" ../ff3d -V 0 $i 2>&1 | tee -a $LOGFILE
done
)

cp $LOGFILE $LOGDIR/freefem-performance-latest
