/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ByReferenceArgumentsTest
extends TestCase {
    TestLibrary lib;

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testByteByReference() {
        ByteByReference bref = new ByteByReference();
        this.lib.incrementInt8ByReference(bref);
        ByReferenceArgumentsTest.assertEquals((String)"Byte argument not modified", (int)1, (int)bref.getValue());
    }

    public void testShortByReference() {
        ShortByReference sref = new ShortByReference();
        this.lib.incrementInt16ByReference(sref);
        ByReferenceArgumentsTest.assertEquals((String)"Short argument not modified", (int)1, (int)sref.getValue());
    }

    public void testIntByReference() {
        IntByReference iref = new IntByReference();
        this.lib.incrementInt32ByReference(iref);
        ByReferenceArgumentsTest.assertEquals((String)"Int argument not modified", (int)1, (int)iref.getValue());
    }

    public void testNativeLongByReference() {
        NativeLongByReference iref = new NativeLongByReference();
        this.lib.incrementNativeLongByReference(iref);
        ByReferenceArgumentsTest.assertEquals((String)"Native long argument not modified", (Object)new NativeLong(1L), (Object)iref.getValue());
    }

    public void testLongByReference() {
        LongByReference lref = new LongByReference();
        this.lib.incrementInt64ByReference(lref);
        ByReferenceArgumentsTest.assertEquals((String)"Long argument not modified", (long)1L, (long)lref.getValue());
    }

    public void testFloatByReference() {
        FloatByReference fref = new FloatByReference(1.0f);
        this.lib.complementFloatByReference(fref);
        ByReferenceArgumentsTest.assertEquals((String)"Float argument not modified", (double)-1.0, (double)fref.getValue(), (double)0.0);
    }

    public void testDoubleByReference() {
        DoubleByReference dref = new DoubleByReference(1.0);
        this.lib.complementDoubleByReference(dref);
        ByReferenceArgumentsTest.assertEquals((String)"Int argument not modified", (double)-1.0, (double)dref.getValue(), (double)0.0);
    }

    public void testPointerByReference() {
        PointerByReference pref = new PointerByReference();
        ByReferenceArgumentsTest.assertNull((String)"Default pointer should be null", (Object)pref.getValue());
        pref = new PointerByReference((Pointer)new Memory(16L));
        ByReferenceArgumentsTest.assertNotNull((String)"Explicit pointer should not be null", (Object)pref.getValue());
        this.lib.setPointerByReferenceNull(pref);
        ByReferenceArgumentsTest.assertNull((String)"Default pointer should be NULL after call", (Object)pref.getValue());
    }

    public static void main(String[] argList) {
        TestRunner.run(ByReferenceArgumentsTest.class);
    }

    public static interface TestLibrary
    extends Library {
        public void incrementInt8ByReference(ByteByReference var1);

        public void incrementInt16ByReference(ShortByReference var1);

        public void incrementInt32ByReference(IntByReference var1);

        public void incrementNativeLongByReference(NativeLongByReference var1);

        public void incrementInt64ByReference(LongByReference var1);

        public void complementFloatByReference(FloatByReference var1);

        public void complementDoubleByReference(DoubleByReference var1);

        public void setPointerByReferenceNull(PointerByReference var1);
    }
}

