/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.IntegerType;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class IntegerTypeTest
extends TestCase {
    public void testWriteNull() {
        class NTStruct
        extends Structure {
            public Sized field;

            NTStruct() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        NTStruct s = new NTStruct();
        IntegerTypeTest.assertNotNull((String)"Field not initialized", (Object)((Object)s.field));
    }

    public void testReadNull() {
        class NTStruct
        extends Structure {
            public Sized field;

            NTStruct() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        NTStruct s = new NTStruct();
        s.read();
        IntegerTypeTest.assertNotNull((String)"Integer type field should be initialized on read", (Object)((Object)s.field));
    }

    public void testCheckArgumentSize() {
        for (int i = 1; i <= 8; i *= 2) {
            long value = -1L << i * 8 - 1;
            new Sized(i, value);
            new Sized(i, -1L);
            new Sized(i, 0L);
            new Sized(i, 1L);
            value = 1L << i * 8 - 1;
            new Sized(i, value);
            value = 0xFFFFFFFFFFFFFFFFL & (-1L << i * 8 ^ 0xFFFFFFFFFFFFFFFFL);
            new Sized(i, value);
            if (i < 8) {
                try {
                    value = 1L << i * 8;
                    new Sized(i, value);
                    IntegerTypeTest.fail((String)("Value exceeding size (" + i + ") should fail"));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if (i >= 8) continue;
            try {
                value = -1L << i * 8;
                new Sized(i, value);
                IntegerTypeTest.fail((String)("Negative value (" + value + ") exceeding size (" + i + ") should fail"));
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public void testInitialValue() {
        long VALUE = 20L;
        NativeLong nl = new NativeLong(VALUE);
        IntegerTypeTest.assertEquals((String)"Wrong initial value", (long)VALUE, (long)nl.longValue());
    }

    public void testValueBoundaries() {
        class TestType
        extends IntegerType {
            public TestType(int size, long value) {
                super(size, value);
            }
        }
        try {
            new TestType(1, 256L);
            IntegerTypeTest.fail((String)"Exception should be thrown if byte value out of bounds");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new TestType(2, 65536L);
            IntegerTypeTest.fail((String)"Exception should be thrown if short value out of bounds");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new TestType(4, 0x100000000L);
            IntegerTypeTest.fail((String)"Exception should be thrown if int value out of bounds");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnsignedValues() {
        long VALUE = 255L;
        class TestType
        extends IntegerType {
            public TestType(int size, long value) {
                super(size, value);
            }
        }
        IntegerTypeTest.assertEquals((String)"Wrong unsigned byte value", (long)VALUE, (long)new TestType(1, VALUE).longValue());
        VALUE = 65535L;
        IntegerTypeTest.assertEquals((String)"Wrong unsigned short value", (long)VALUE, (long)new TestType(2, VALUE).longValue());
        VALUE = -1L;
        IntegerTypeTest.assertEquals((String)"Wrong unsigned int value", (long)VALUE, (long)new TestType(4, VALUE).longValue());
        class UnsignedTestType
        extends IntegerType {
            public UnsignedTestType(int size, long value) {
                super(size, value, true);
            }
        }
        UnsignedTestType tt = new UnsignedTestType(4, -1L);
        IntegerTypeTest.assertTrue((String)("Expected an unsigned value (ctor): " + tt.longValue()), (tt.longValue() > 0L ? 1 : 0) != 0);
        tt.setValue(-2L);
        IntegerTypeTest.assertTrue((String)("Expected an unsigned value: " + tt.longValue()), (tt.longValue() > 0L ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run(IntegerTypeTest.class);
    }

    public static class Sized
    extends IntegerType {
        public Sized() {
            this(4, 0L);
        }

        public Sized(int size, long value) {
            super(size, value);
        }
    }
}

