/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class NativeTest
extends TestCase {
    public void testLongStringGeneration() {
        StringBuffer buf = new StringBuffer();
        int MAX = Platform.isWindowsCE() ? 200000 : 2000000;
        for (int i = 0; i < MAX; ++i) {
            buf.append('a');
        }
        String s1 = buf.toString();
        Memory m = new Memory((long)((MAX + 1) * Native.WCHAR_SIZE));
        m.setString(0L, s1, true);
        NativeTest.assertEquals((String)"Missing terminator after write", (int)0, (int)m.getChar((long)(MAX * Native.WCHAR_SIZE)));
        String s2 = m.getString(0L, true);
        NativeTest.assertEquals((String)"Wrong string read length", (int)s1.length(), (int)s2.length());
        NativeTest.assertEquals((String)"Improper wide string read", (String)s1, (String)s2);
    }

    public void testDefaultStringEncoding() throws Exception {
        String encoding = System.getProperty("file.encoding");
        String unicode = "Un \u00e9l\u00e9ment gr\u00e2ce \u00e0 l'index";
        if (!unicode.equals(new String(unicode.getBytes()))) {
            unicode = "";
            for (char ch = '\u0001'; ch < '\u0080'; ch = (char)(ch + '\u0001')) {
                unicode = unicode + ch;
            }
        }
        String unicodez = unicode + "\u0000more stuff";
        byte[] defaultEncoded = Native.getBytes((String)unicode);
        byte[] expected = unicode.getBytes();
        for (int i = 0; i < Math.min(defaultEncoded.length, expected.length); ++i) {
            NativeTest.assertEquals((String)("Improperly encoded (" + encoding + ") from Java at " + i), (byte)expected[i], (byte)defaultEncoded[i]);
        }
        NativeTest.assertEquals((String)("Wrong number of encoded characters (" + encoding + ")"), (int)expected.length, (int)defaultEncoded.length);
        String result = Native.toString((byte[])defaultEncoded);
        NativeTest.assertEquals((String)("Improperly decoded from native bytes (" + encoding + ")"), (String)unicode, (String)result);
        NativeTest.assertEquals((String)"Should truncate bytes at NUL terminator", (String)unicode, (String)Native.toString((byte[])unicodez.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomStringEncoding() throws Exception {
        Properties oldprops = (Properties)System.getProperties().clone();
        try {
            String encoding = "UTF8";
            System.setProperty("jna.encoding", encoding);
            String unicode = "\u0444\u043b\u0441\u0432\u0443";
            String unicodez = unicode + "\u0000more stuff";
            byte[] utf8 = Native.getBytes((String)unicode);
            byte[] expected = unicode.getBytes(encoding);
            for (int i = 0; i < Math.min(utf8.length, expected.length); ++i) {
                NativeTest.assertEquals((String)("Improperly encoded at " + i), (byte)expected[i], (byte)utf8[i]);
            }
            NativeTest.assertEquals((String)"Wrong number of encoded characters", (int)expected.length, (int)utf8.length);
            String result = Native.toString((byte[])utf8);
            NativeTest.assertEquals((String)"Improperly decoded", (String)unicode, (String)result);
            NativeTest.assertEquals((String)"Should truncate bytes at NUL terminator", (String)unicode, (String)Native.toString((byte[])unicodez.getBytes(encoding)));
        }
        finally {
            System.setProperties(oldprops);
        }
    }

    public void testSynchronizedAccess() throws Exception {
        final boolean[] lockHeld = new boolean[]{false};
        final NativeLibrary nlib = NativeLibrary.getInstance((String)"testlib");
        final TestLib lib = (TestLib)Native.loadLibrary((String)"testlib", TestLib.class);
        final TestLib synchlib = (TestLib)Native.synchronizedLibrary((Library)lib);
        final TestLib.VoidCallback cb = new TestLib.VoidCallback(){

            public void callback() {
                lockHeld[0] = Thread.holdsLock(nlib);
            }
        };
        Thread t0 = new Thread(){

            public void run() {
                lib.callVoidCallback(cb);
            }
        };
        t0.start();
        t0.join();
        NativeTest.assertFalse((String)"NativeLibrary lock should not be held during native call to normal library", (boolean)lockHeld[0]);
        Thread t1 = new Thread(){

            public void run() {
                synchlib.callVoidCallback(cb);
            }
        };
        t1.start();
        t1.join();
        NativeTest.assertTrue((String)"NativeLibrary lock should be held during native call to synchronized library", (boolean)lockHeld[0]);
    }

    public void testFindInterfaceClass() throws Exception {
        Class<TestInterface> interfaceClass = TestInterface.class;
        Class<TestInterface.InnerTestClass> cls = TestInterface.InnerTestClass.class;
        Class<TestInterface.InnerTestClass.InnerSubclass> subClass = TestInterface.InnerTestClass.InnerSubclass.class;
        Class<TestInterface.InnerTestClass.TestCallback> callbackClass = TestInterface.InnerTestClass.TestCallback.class;
        NativeTest.assertEquals((String)"Enclosing interface not found for class", interfaceClass, (Object)Native.findEnclosingLibraryClass(cls));
        NativeTest.assertEquals((String)"Enclosing interface not found for derived class", interfaceClass, (Object)Native.findEnclosingLibraryClass(subClass));
        NativeTest.assertEquals((String)"Enclosing interface not found for callback", interfaceClass, (Object)Native.findEnclosingLibraryClass(callbackClass));
    }

    public void testOptionsInferenceFromInstanceField() {
        NativeTest.assertEquals((String)"Wrong options found for interface which provides an instance", (Object)TestInterfaceWithInstance.TEST_OPTS, (Object)Native.getLibraryOptions(TestInterfaceWithInstance.class));
        NativeTest.assertEquals((String)"Wrong type mapper found", (Object)TestInterfaceWithInstance.TEST_MAPPER, (Object)Native.getTypeMapper(TestInterfaceWithInstance.class));
        NativeTest.assertEquals((String)"Wrong alignment found", (int)1, (int)Native.getStructureAlignment(TestInterfaceWithInstance.class));
    }

    public void testOptionsInferenceFromOptionsField() {
        NativeTest.assertEquals((String)"Wrong options found for interface which provides OPTIONS", (Object)TestInterfaceWithOptions.OPTIONS, (Object)Native.getLibraryOptions(TestInterfaceWithOptions.class));
        NativeTest.assertEquals((String)"Wrong type mapper found", (Object)TestInterfaceWithOptions.TEST_MAPPER, (Object)Native.getTypeMapper(TestInterfaceWithOptions.class));
        NativeTest.assertEquals((String)"Wrong alignment found", (int)1, (int)Native.getStructureAlignment(TestInterfaceWithOptions.class));
    }

    public void testOptionsInferenceFromTypeMapperField() {
        NativeTest.assertEquals((String)"Wrong type mapper found for interface which provides TYPE_MAPPER", (Object)TestInterfaceWithTypeMapper.TEST_MAPPER, (Object)Native.getTypeMapper(TestInterfaceWithTypeMapper.class));
    }

    public void testOptionsInferenceFromAlignmentField() {
        NativeTest.assertEquals((String)"Wrong alignment found for interface which provides STRUCTURE_ALIGNMENT", (int)1, (int)Native.getStructureAlignment(TestInterfaceWithAlignment.class));
    }

    public void testCharArrayToString() {
        char[] buf = new char[]{'a', 'b', 'c', '\u0000', 'd', 'e'};
        NativeTest.assertEquals((String)"Wrong String generated", (String)"abc", (String)Native.toString((char[])buf));
    }

    public void testByteArrayToString() {
        byte[] buf = new byte[]{97, 98, 99, 0, 100, 101};
        NativeTest.assertEquals((String)"Wrong String generated", (String)"abc", (String)Native.toString((byte[])buf));
    }

    public void testToByteArray() {
        String VALUE = this.getName();
        byte[] buf = Native.toByteArray((String)VALUE);
        NativeTest.assertEquals((String)"Wrong byte array length", (int)(VALUE.length() + 1), (int)buf.length);
        NativeTest.assertEquals((String)"Missing NUL terminator", (byte)0, (byte)buf[buf.length - 1]);
        NativeTest.assertEquals((String)"Wrong byte array contents", (String)VALUE, (String)new String(buf, 0, buf.length - 1));
    }

    public void testToCharArray() {
        String VALUE = this.getName();
        char[] buf = Native.toCharArray((String)VALUE);
        NativeTest.assertEquals((String)"Wrong char array length", (int)(VALUE.length() + 1), (int)buf.length);
        NativeTest.assertEquals((String)"Missing NUL terminator", (char)'\u0000', (char)buf[buf.length - 1]);
        NativeTest.assertEquals((String)("Wrong char array contents: " + new String(buf)), (String)VALUE, (String)new String(buf, 0, buf.length - 1));
    }

    public void testOSPrefix() {
        NativeTest.assertEquals((String)"Wrong resource path", (String)"win32-x86", (String)Native.getNativeLibraryResourcePrefix((int)2, (String)"x86", (String)"Windows"));
        NativeTest.assertEquals((String)"Wrong resource path Windows/i386", (String)"win32-x86", (String)Native.getNativeLibraryResourcePrefix((int)2, (String)"i386", (String)"Windows"));
        NativeTest.assertEquals((String)"Wrong resource path Windows CE/arm", (String)"w32ce-arm", (String)Native.getNativeLibraryResourcePrefix((int)6, (String)"arm", (String)"Windows CE"));
        NativeTest.assertEquals((String)"Wrong resource path Mac/x86", (String)"darwin", (String)Native.getNativeLibraryResourcePrefix((int)0, (String)"x86", (String)"Darwin"));
        NativeTest.assertEquals((String)"Wrong resource path Mac/x86_64", (String)"darwin", (String)Native.getNativeLibraryResourcePrefix((int)0, (String)"x86_64", (String)"Mac"));
        NativeTest.assertEquals((String)"Wrong resource path Solaris/sparc", (String)"sunos-sparc", (String)Native.getNativeLibraryResourcePrefix((int)3, (String)"sparc", (String)"Solaris"));
        NativeTest.assertEquals((String)"Wrong resource path SunOS/sparcv9", (String)"sunos-sparcv9", (String)Native.getNativeLibraryResourcePrefix((int)3, (String)"sparcv9", (String)"SunOS"));
        NativeTest.assertEquals((String)"Wrong resource path Linux/i386", (String)"linux-i386", (String)Native.getNativeLibraryResourcePrefix((int)1, (String)"i386", (String)"Linux/Gnu"));
        NativeTest.assertEquals((String)"Wrong resource path Linux/x86", (String)"linux-i386", (String)Native.getNativeLibraryResourcePrefix((int)1, (String)"x86", (String)"Linux"));
        NativeTest.assertEquals((String)"Wrong resource path Linux/ppc", (String)"linux-ppc", (String)Native.getNativeLibraryResourcePrefix((int)1, (String)"powerpc", (String)"Linux"));
        NativeTest.assertEquals((String)"Wrong resource path OpenBSD/x86", (String)"openbsd-i386", (String)Native.getNativeLibraryResourcePrefix((int)5, (String)"x86", (String)"OpenBSD"));
        NativeTest.assertEquals((String)"Wrong resource path FreeBSD/x86", (String)"freebsd-i386", (String)Native.getNativeLibraryResourcePrefix((int)4, (String)"x86", (String)"FreeBSD"));
        NativeTest.assertEquals((String)"Wrong resource path Linux/armv7l (android)", (String)"android-arm", (String)Native.getNativeLibraryResourcePrefix((int)8, (String)"armv7l", (String)"Linux"));
        NativeTest.assertEquals((String)"Wrong resource path other/other", (String)"name-ppc", (String)Native.getNativeLibraryResourcePrefix((int)-1, (String)"PowerPC", (String)"Name Of System"));
    }

    public void testGetTypeMapperForDirectMapping() {
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        options.put("type-mapper", mapper);
        DirectMapping lib = new DirectMapping(options);
        NativeTest.assertEquals((String)"Wrong type mapper for direct mapping", (Object)mapper, (Object)Native.getTypeMapper(DirectMapping.class));
        NativeTest.assertEquals((String)"Wrong type mapper for direct mapping nested structure", (Object)mapper, (Object)Native.getTypeMapper(DirectMapping.DirectStructure.class));
        NativeTest.assertEquals((String)"Wrong type mapper for direct mapping nested callback", (Object)mapper, (Object)Native.getTypeMapper(DirectMapping.DirectCallback.class));
    }

    public void testGetTypeMapperFromCallbackInterface() throws Exception {
        NativeTest.assertEquals((String)"Wrong type mapper for callback class", (Object)TestCallback.TYPE_MAPPER, (Object)Native.getTypeMapper(TestCallback.class));
    }

    public void testStringReplace() {
        NativeTest.assertEquals((String)"Bad replace", (String)"abcdefg", (String)Native.replace((String)"z", (String)"a", (String)"zbcdefg"));
        NativeTest.assertEquals((String)"Bad replace", (String)"abcdefg", (String)Native.replace((String)"z", (String)"g", (String)"abcdefz"));
        NativeTest.assertEquals((String)"Bad replace", (String)"abcdefg", (String)Native.replace((String)"z", (String)"d", (String)"abczefg"));
        NativeTest.assertEquals((String)"Bad replace", (String)"abcaefa", (String)Native.replace((String)"z", (String)"a", (String)"zbczefz"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveTemporaries() throws Exception {
        File dir = Native.getTempDir();
        File tmp = new File(dir, "jna");
        tmp.delete();
        try {
            NativeTest.assertTrue((String)("Couldn't create temporary file " + tmp), (boolean)tmp.createNewFile());
            NativeTest.assertTrue((String)"File isn't recognized as unpacked", (boolean)Native.isUnpacked((File)tmp));
            Native.markTemporaryFile((File)tmp);
            Native.removeTemporaryFiles();
            NativeTest.assertFalse((String)"Temporary file still exists", (boolean)tmp.exists());
        }
        finally {
            tmp.delete();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TestRunner.run(NativeTest.class);
        } else {
            if (args.length == 1 && "all".equals(args[0])) {
                args = new String[]{"com.sun.jna.NativeTest", "com.sun.jna.NativeLibraryTest", "com.sun.jna.PointerTest", "com.sun.jna.MemoryTest", "com.sun.jna.LibraryLoadTest", "com.sun.jna.ArgumentsMarshalTest", "com.sun.jna.ReturnTypesTest", "com.sun.jna.TypeMapperTest", "com.sun.jna.ByReferenceArgumentsTest", "com.sun.jna.LastErrorTest", "com.sun.jna.StructureTest", "com.sun.jna.StructureByValueTest", "com.sun.jna.UnionTest", "com.sun.jna.IntegerTypeTest", "com.sun.jna.VMCrashProtectionTest", "com.sun.jna.CallbacksTest", "com.sun.jna.JNAUnloadTest", "com.sun.jna.DirectTest", "com.sun.jna.DirectArgumentsMarshalTest", "com.sun.jna.DirectByReferenceArgumentsTest", "com.sun.jna.DirectTypeMapperTest", "com.sun.jna.DirectReturnTypesTest", "com.sun.jna.DirectStructureByValueTest", "com.sun.jna.DirectCallbacksTest"};
            }
            System.out.println("Test suites: " + args.length);
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Running tests on class " + args[i]);
                try {
                    TestRunner.run(Class.forName(args[i]));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(300000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TestCallback
    implements Callback {
        public static final TypeMapper TYPE_MAPPER = new DefaultTypeMapper();

        private TestCallback() {
        }

        public void callback() {
        }
    }

    public static class DirectMapping {
        public DirectMapping(Map options) {
            Native.register(this.getClass(), (NativeLibrary)NativeLibrary.getInstance((String)"testlib", (Map)options));
        }

        public static interface DirectCallback
        extends Callback {
            public void invoke();
        }

        public static class DirectStructure
        extends Structure {
            public int field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
    }

    public static interface TestInterfaceWithAlignment
    extends Library {
        public static final int STRUCTURE_ALIGNMENT = 1;
    }

    public static interface TestInterfaceWithTypeMapper
    extends Library {
        public static final TypeMapper TEST_MAPPER;
        public static final TypeMapper TYPE_MAPPER;

        static {
            TYPE_MAPPER = TEST_MAPPER = new DefaultTypeMapper();
        }
    }

    public static interface TestInterfaceWithOptions
    extends Library {
        public static final int TEST_ALIGNMENT = 1;
        public static final TypeMapper TEST_MAPPER = new DefaultTypeMapper();
        public static final Map OPTIONS = new HashMap(){
            {
                this.put("type-mapper", TEST_MAPPER);
                this.put("structure-alignment", new Integer(1));
            }
        };
    }

    public static interface TestInterfaceWithInstance
    extends Library {
        public static final int TEST_ALIGNMENT = 1;
        public static final TypeMapper TEST_MAPPER = new DefaultTypeMapper();
        public static final Map TEST_OPTS = new HashMap(){
            {
                this.put("type-mapper", TEST_MAPPER);
                this.put("structure-alignment", new Integer(1));
            }
        };
        public static final TestInterfaceWithInstance ARBITRARY = (TestInterfaceWithInstance)Native.loadLibrary((String)"testlib", TestInterfaceWithInstance.class, (Map)TEST_OPTS);
    }

    static interface TestInterface
    extends Library {

        public static class InnerTestClass
        extends Structure {
            protected List getFieldOrder() {
                return Collections.EMPTY_LIST;
            }

            static class InnerSubclass
            extends InnerTestClass
            implements Structure.ByReference {
                InnerSubclass() {
                }
            }

            static interface TestCallback
            extends Callback {
            }
        }
    }

    public static interface TestLib
    extends Library {
        public void callVoidCallback(VoidCallback var1);

        public static interface VoidCallback
        extends Callback {
            public void callback();
        }
    }
}

