/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class PointerTest
extends TestCase {
    public void testGetNativeLong() {
        Memory m = new Memory(8L);
        if (NativeLong.SIZE == 4) {
            int MAGIC = -1410478301;
            m.setInt(0L, -1410478301);
            NativeLong l = m.getNativeLong(0L);
            PointerTest.assertEquals((String)"Native long mismatch", (int)-1410478301, (int)l.intValue());
        } else {
            long MAGIC = 1311768467139281697L;
            m.setLong(0L, 1311768467139281697L);
            NativeLong l = m.getNativeLong(0L);
            PointerTest.assertEquals((String)"Native long mismatch", (long)1311768467139281697L, (long)l.longValue());
        }
    }

    public void testSetNativeLong() {
        Memory m = new Memory(8L);
        if (NativeLong.SIZE == 4) {
            int MAGIC = -1410478301;
            m.setNativeLong(0L, new NativeLong(-1410478301L));
            PointerTest.assertEquals((String)"Native long mismatch", (int)-1410478301, (int)m.getInt(0L));
        } else {
            long MAGIC = 1311768467139281697L;
            m.setNativeLong(0L, new NativeLong(1311768467139281697L));
            PointerTest.assertEquals((String)"Native long mismatch", (long)1311768467139281697L, (long)m.getLong(0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetStringWithEncoding() throws Exception {
        String old = System.getProperty("jna.encoding");
        String VALUE = "\u0444\u0438\u0441\u0432\u0443";
        System.setProperty("jna.encoding", "UTF8");
        try {
            int size = VALUE.getBytes("UTF8").length + 1;
            Memory m = new Memory((long)size);
            m.setString(0L, VALUE);
            PointerTest.assertEquals((String)"UTF8 encoding should be double", (int)(VALUE.length() * 2 + 1), (int)size);
            PointerTest.assertEquals((String)"Wrong decoded value", (String)VALUE, (String)m.getString(0L));
        }
        finally {
            if (old != null) {
                System.setProperty("jna.encoding", old);
            } else {
                Properties props = System.getProperties();
                props.remove("jna.encoding");
                Properties newProps = new Properties();
                for (Map.Entry e : props.entrySet()) {
                    newProps.setProperty(e.getKey().toString(), e.getValue().toString());
                }
                System.setProperties(newProps);
            }
        }
    }

    public void testSetNativeMapped() {
        Memory p = new Memory((long)Pointer.SIZE);
        TestPointerType tp = new TestPointerType((Pointer)p);
        p.setValue(0L, (Object)tp, ((Object)((Object)tp)).getClass());
        PointerTest.assertEquals((String)"Wrong value written", (Object)p, (Object)p.getPointer(0L));
    }

    public void testGetNativeMapped() {
        Memory p = new Memory((long)Pointer.SIZE);
        p.setPointer(0L, null);
        Object o = p.getValue(0L, TestPointerType.class, null);
        PointerTest.assertNull((String)("Wrong empty value: " + o), (Object)o);
        p.setPointer(0L, (Pointer)p);
        TestPointerType tp = new TestPointerType((Pointer)p);
        PointerTest.assertEquals((String)"Wrong value", (Object)((Object)tp), (Object)p.getValue(0L, TestPointerType.class, null));
    }

    public void testGetStringArray() {
        Memory p = new Memory((long)(Pointer.SIZE * 3));
        String VALUE1 = this.getName();
        String VALUE2 = this.getName() + "2";
        p.setPointer(0L, new NativeString(VALUE1).getPointer());
        p.setPointer((long)Pointer.SIZE, new NativeString(VALUE2).getPointer());
        p.setPointer((long)(Pointer.SIZE * 2), null);
        PointerTest.assertEquals((String)"Wrong null-terminated String array", Arrays.asList(VALUE1, VALUE2), Arrays.asList(p.getStringArray(0L)));
        PointerTest.assertEquals((String)"Wrong length-specified String array (1)", Arrays.asList(VALUE1), Arrays.asList(p.getStringArray(0L, 1)));
        PointerTest.assertEquals((String)"Wrong length-specified String array (2)", Arrays.asList(VALUE1, VALUE2), Arrays.asList(p.getStringArray(0L, 2)));
    }

    public void testReadPointerArray() {
        Memory mem = new Memory((long)(Pointer.SIZE * 2));
        Pointer[] p = new Pointer[2];
        String VALUE1 = this.getName();
        p[0] = new NativeString(VALUE1).getPointer();
        p[1] = new Memory(1024L);
        Pointer[] orig = new Pointer[p.length];
        System.arraycopy(p, 0, orig, 0, p.length);
        mem.write(0L, p, 0, p.length);
        mem.read(0L, p, 0, p.length);
        PointerTest.assertSame((String)"Pointer object not preserved[0]", (Object)orig[0], (Object)p[0]);
        PointerTest.assertSame((String)"Pointer object not preserved[1]", (Object)orig[1], (Object)p[1]);
        mem.setPointer(0L, null);
        mem.setPointer((long)Pointer.SIZE, (Pointer)new Memory(1024L));
        mem.read(0L, p, 0, p.length);
        PointerTest.assertNull((String)"Pointer element not updated[0]", (Object)p[0]);
        PointerTest.assertNotSame((String)"Pointer element not updated[1]", (Object)orig[1], (Object)p[1]);
    }

    public void testCreateConstantPointer() {
        Pointer p = Pointer.createConstant((int)-1);
        PointerTest.assertEquals((String)"Wrong peer value", (long)p.peer, (long)-1L);
        p = Pointer.createConstant((int)-1);
        PointerTest.assertEquals((String)"Wrong peer value", (long)p.peer, (long)-1L);
    }

    public void testReadStringArrayNULLElement() {
        Memory m = new Memory((long)Pointer.SIZE);
        m.clear();
        String[] arr = m.getStringArray(0L, 1);
        PointerTest.assertEquals((String)"Wrong array size", (int)1, (int)arr.length);
        PointerTest.assertNull((String)"Array element should be null", (Object)arr[0]);
    }

    public static void main(String[] args) {
        TestRunner.run(PointerTest.class);
    }

    public static class TestPointerType
    extends PointerType {
        public TestPointerType() {
        }

        public TestPointerType(Pointer p) {
            super(p);
        }
    }
}

