/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class StructureBufferFieldTest
extends TestCase {
    public static void main(String[] argList) {
        TestRunner.run(StructureBufferFieldTest.class);
    }

    public void testBufferFieldWriteNULL() {
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        BufferStructure bs = new BufferStructure();
        bs.write();
    }

    public void testBufferFieldWriteNonNULL() {
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        BufferStructure bs = new BufferStructure();
        bs.buffer = ByteBuffer.allocateDirect(16);
        bs.dbuffer = ((ByteBuffer)bs.buffer).asDoubleBuffer();
        bs.write();
    }

    public void testBufferFieldReadUnchanged() {
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        BufferStructure bs = new BufferStructure();
        ByteBuffer b = ByteBuffer.allocateDirect(16);
        bs.buffer = b;
        bs.dbuffer = ((ByteBuffer)bs.buffer).asDoubleBuffer();
        bs.write();
        bs.read();
        StructureBufferFieldTest.assertEquals((String)"Buffer field should be unchanged", (Object)b, (Object)bs.buffer);
    }

    public void testBufferFieldReadChanged() {
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        BufferStructure bs = new BufferStructure();
        if (Pointer.SIZE == 4) {
            bs.getPointer().setInt(0L, 1);
        } else {
            bs.getPointer().setLong(0L, 1L);
        }
        try {
            bs.read();
            StructureBufferFieldTest.fail((String)"Structure read should fail if Buffer pointer was set");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        bs.buffer = ByteBuffer.allocateDirect(16);
        try {
            bs.read();
            StructureBufferFieldTest.fail((String)"Structure read should fail if Buffer pointer has changed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBufferFieldReadChangedToNULL() {
        if (!Platform.HAS_BUFFERS) {
            return;
        }
        BufferStructure bs = new BufferStructure();
        bs.buffer = ByteBuffer.allocateDirect(16);
        bs.dbuffer = ((ByteBuffer)bs.buffer).asDoubleBuffer();
        bs.read();
        StructureBufferFieldTest.assertNull((String)"Structure Buffer field should be set null", (Object)bs.buffer);
        StructureBufferFieldTest.assertNull((String)"Structure DoubleBuffer field should be set null", (Object)bs.dbuffer);
    }

    static class BufferStructure
    extends Structure {
        public Buffer buffer;
        public DoubleBuffer dbuffer;

        BufferStructure() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("buffer", "dbuffer");
        }
    }
}

