/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TypeMapperTest
extends TestCase {
    public void testBooleanToIntArgumentConversion() {
        int MAGIC = -1410478301;
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addToNativeConverter(Boolean.class, new ToNativeConverter(){

            public Object toNative(Object arg, ToNativeContext ctx) {
                return new Integer(Boolean.TRUE.equals(arg) ? -1410478301 : 0);
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        options.put("type-mapper", mapper);
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, options);
        TypeMapperTest.assertEquals((String)"Failed to convert Boolean argument to Int", (int)-1410478301, (int)lib.returnInt32Argument(true));
    }

    public void testStringToIntArgumentConversion() {
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addToNativeConverter(String.class, new ToNativeConverter(){

            public Object toNative(Object arg, ToNativeContext ctx) {
                return Integer.valueOf((String)arg, 16);
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        options.put("type-mapper", mapper);
        int MAGIC = 2079182627;
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, options);
        TypeMapperTest.assertEquals((String)"Failed to convert String argument to Int", (int)2079182627, (int)lib.returnInt32Argument(Integer.toHexString(2079182627)));
    }

    public void testCharSequenceToIntArgumentConversion() {
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addToNativeConverter(CharSequence.class, new ToNativeConverter(){

            public Object toNative(Object arg, ToNativeContext ctx) {
                return Integer.valueOf(((Object)((CharSequence)arg)).toString(), 16);
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        options.put("type-mapper", mapper);
        int MAGIC = 2079182627;
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, options);
        TypeMapperTest.assertEquals((String)"Failed to convert String argument to Int", (int)2079182627, (int)lib.returnInt32Argument(Integer.toHexString(2079182627)));
    }

    public void testNumberToIntArgumentConversion() {
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addToNativeConverter(Double.class, new ToNativeConverter(){

            public Object toNative(Object arg, ToNativeContext ctx) {
                return new Integer(((Double)arg).intValue());
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        options.put("type-mapper", mapper);
        int MAGIC = 2079182627;
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, options);
        TypeMapperTest.assertEquals((String)"Failed to convert Double argument to Int", (int)2079182627, (int)lib.returnInt32Argument(new Double(2.079182627E9)));
    }

    public void testIntegerToBooleanResultConversion() throws Exception {
        int MAGIC = -1410478301;
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addToNativeConverter(Boolean.class, new ToNativeConverter(){

            public Object toNative(Object value, ToNativeContext ctx) {
                return new Integer(Boolean.TRUE.equals(value) ? -1410478301 : 0);
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        mapper.addFromNativeConverter(Boolean.class, new FromNativeConverter(){

            public Object fromNative(Object value, FromNativeContext context) {
                return (Integer)value == -1410478301;
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        options.put("type-mapper", mapper);
        BooleanTestLibrary lib = (BooleanTestLibrary)Native.loadLibrary((String)"testlib", BooleanTestLibrary.class, options);
        TypeMapperTest.assertEquals((String)"Failed to convert integer return to boolean TRUE", (boolean)true, (boolean)lib.returnInt32Argument(true));
        TypeMapperTest.assertEquals((String)"Failed to convert integer return to boolean FALSE", (boolean)false, (boolean)lib.returnInt32Argument(false));
    }

    public void testStructureConversion() throws Exception {
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        TypeConverter converter = new TypeConverter(){

            public Object toNative(Object value, ToNativeContext ctx) {
                return new Integer(Boolean.TRUE.equals(value) ? 1 : 0);
            }

            public Object fromNative(Object value, FromNativeContext context) {
                return new Boolean((Integer)value == 1);
            }

            public Class nativeType() {
                return Integer.class;
            }
        };
        mapper.addTypeConverter(Boolean.class, converter);
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        options.put("type-mapper", mapper);
        StructureTestLibrary lib = (StructureTestLibrary)Native.loadLibrary((String)"testlib", StructureTestLibrary.class, options);
        StructureTestLibrary.TestStructure s = new StructureTestLibrary.TestStructure((TypeMapper)mapper);
        TypeMapperTest.assertEquals((String)"Wrong native size", (int)4, (int)s.size());
        s.data = true;
        s.write();
        TypeMapperTest.assertEquals((String)"Wrong value written", (int)1, (int)s.getPointer().getInt(0L));
        s.getPointer().setInt(0L, 0);
        s.read();
        TypeMapperTest.assertFalse((String)"Wrong value read", (boolean)s.data);
    }

    public static void main(String[] args) {
        TestRunner.run(TypeMapperTest.class);
    }

    public static interface StructureTestLibrary
    extends Library {

        public static class TestStructure
        extends Structure {
            public boolean data;

            public TestStructure(TypeMapper mapper) {
                super(mapper);
            }

            protected List getFieldOrder() {
                return Arrays.asList("data");
            }
        }
    }

    public static interface BooleanTestLibrary
    extends Library {
        public boolean returnInt32Argument(boolean var1);
    }

    public static interface TestLibrary
    extends Library {
        public int returnInt32Argument(boolean var1);

        public int returnInt32Argument(String var1);

        public int returnInt32Argument(Number var1);
    }
}

