/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.chrono;

import clover.cenqua_com_licensing.atlassian.time.DateTimeFieldType;
import clover.cenqua_com_licensing.atlassian.time.DurationField;
import clover.cenqua_com_licensing.atlassian.time.ReadablePartial;
import clover.cenqua_com_licensing.atlassian.time.chrono.BasicChronology;
import clover.cenqua_com_licensing.atlassian.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfMonth(), durationField);
        this.iChronology = basicChronology;
    }

    public int get(long l) {
        return this.iChronology.getDayOfMonth(l);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }

    public int getMaximumValue(long l) {
        return this.iChronology.getDaysInMonthMax(l);
    }

    public int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.monthOfYear())) {
            int n = readablePartial.get(DateTimeFieldType.monthOfYear());
            if (readablePartial.isSupported(DateTimeFieldType.year())) {
                int n2 = readablePartial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(n2, n);
            }
            return this.iChronology.getDaysInMonthMax(n);
        }
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n = readablePartial.size();
        int n2 = 0;
        while (n2 < n) {
            if (readablePartial.getFieldType(n2) == DateTimeFieldType.monthOfYear()) {
                int n3 = nArray[n2];
                int n4 = 0;
                while (n4 < n) {
                    if (readablePartial.getFieldType(n4) == DateTimeFieldType.year()) {
                        int n5 = nArray[n4];
                        return this.iChronology.getDaysInYearMonth(n5, n3);
                    }
                    ++n4;
                }
                return this.iChronology.getDaysInMonthMax(n3);
            }
            ++n2;
        }
        return this.getMaximumValue();
    }

    protected int getMaximumValueForSet(long l, int n) {
        return this.iChronology.getDaysInMonthMaxForSet(l, n);
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

