/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.DocWriter;
import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.pdf.PdfEncryption;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PdfIndirectObject {
    protected int number;
    protected int generation = 0;
    protected int type;
    protected ByteArrayOutputStream bytes;
    static final byte[] STARTOBJ = DocWriter.getISOBytes(" obj\n");
    static final byte[] ENDOBJ = DocWriter.getISOBytes("\nendobj\n");
    static final int SIZEOBJ = STARTOBJ.length + ENDOBJ.length;
    boolean isStream = false;
    PdfStream stream;
    PdfWriter writer;

    PdfIndirectObject(int n, PdfObject pdfObject, PdfWriter pdfWriter) {
        this(n, 0, pdfObject, pdfWriter);
    }

    PdfIndirectObject(PdfIndirectReference pdfIndirectReference, PdfObject pdfObject, PdfWriter pdfWriter) {
        this(pdfIndirectReference.getNumber(), pdfIndirectReference.getGeneration(), pdfObject, pdfWriter);
    }

    PdfIndirectObject(int n, int n2, PdfObject pdfObject, PdfWriter pdfWriter) {
        this.writer = pdfWriter;
        this.number = n;
        this.generation = n2;
        this.type = pdfObject.type();
        this.isStream = pdfObject.type() == 7;
        PdfEncryption pdfEncryption = pdfWriter.getEncryption();
        if (pdfEncryption != null) {
            pdfEncryption.setHashKey(n, n2);
        }
        try {
            this.bytes = new ByteArrayOutputStream();
            this.bytes.write(DocWriter.getISOBytes(String.valueOf(n)));
            this.bytes.write(32);
            this.bytes.write(DocWriter.getISOBytes(String.valueOf(n2)));
            if (!this.isStream) {
                this.bytes.write(STARTOBJ);
                this.bytes.write(pdfObject.toPdf(pdfWriter));
                this.bytes.write(ENDOBJ);
            } else {
                this.stream = (PdfStream)pdfObject;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public int length() {
        if (this.isStream) {
            return this.bytes.size() + SIZEOBJ + this.stream.getStreamLength(this.writer);
        }
        return this.bytes.size();
    }

    PdfIndirectReference getIndirectReference() {
        return new PdfIndirectReference(this.type, this.number, this.generation);
    }

    void writeTo(OutputStream outputStream) throws IOException {
        this.bytes.writeTo(outputStream);
        if (this.isStream) {
            outputStream.write(STARTOBJ);
            this.stream.writeTo(outputStream, this.writer);
            outputStream.write(ENDOBJ);
        }
    }
}

