/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.tasks.CloverHtmlReportTask;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import com.cenqua.clover.test.optimization.Optimizable;
import com.cenqua.clover.test.optimization.Options;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.util.ClassPathUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.CloverCompilerAdapter;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntIntegrationListener
implements BuildListener {
    private Options optimizationOptions;
    private boolean instrumentationOccured;
    private boolean unitTestingOccured;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter;

    public void buildStarted(BuildEvent buildEvent) {
        AntInstrumentationConfig cfg = this.getConfigForProject(buildEvent.getProject());
        this.optimizationOptions = Options.newDefaults().withDefaultInitStringAndSnapshotFrom(cfg);
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (!this.instrumentationOccured && !this.unitTestingOccured) {
            return;
        }
        try {
            Snapshot.generateFor(this.optimizationOptions.getInitString()).store();
        }
        catch (IOException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error(new StringBuffer().append("Problem writing snapshot file: ").append(e.getMessage()).toString());
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error(new StringBuffer().append("Problem writing snapshot file: ").append(e.getMessage()).toString());
        }
        CloverHtmlReportTask reporter = new CloverHtmlReportTask();
        reporter.setProject(buildEvent.getProject());
        reporter.setTaskName("clover-html-report");
        reporter.init();
        reporter.setInitString(this.optimizationOptions.getInitString());
        reporter.setOutdir(new File(buildEvent.getProject().getBaseDir(), "clover_html"));
        reporter.perform();
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
        AntInstrumentationConfig cfg = this.getConfigForProject(buildEvent.getProject());
        Task task = buildEvent.getTask();
        if ("javac".equals(task.getTaskName())) {
            this.injectClover(cfg, (Javac)this.getConfiguredTask(task));
        } else if ("junit".equals(task.getTaskName())) {
            this.injectClover(cfg, (JUnitTask)this.getConfiguredTask(task));
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    private AntInstrumentationConfig getConfigForProject(Project project) {
        AntInstrumentationConfig instrConfig = (AntInstrumentationConfig)project.getReference("clover.config");
        if (instrConfig == null) {
            instrConfig = new AntInstrumentationConfig(project);
            project.addReference("clover.config", (Object)instrConfig);
        }
        return instrConfig;
    }

    private Object getConfiguredTask(Task task) {
        UnknownElement ue = (UnknownElement)task.getRuntimeConfigurableWrapper().getProxy();
        ue.maybeConfigure();
        return ue.getRealThing();
    }

    private void injectClover(AntInstrumentationConfig cfg, Javac javac) {
        javac.setClasspath(new Path(javac.getProject(), ClassPathUtil.getCloverJarPath()));
        String origCompiler = javac.getCompiler();
        Class<?> clazz = class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$taskdefs$CloverCompilerAdapter = new CloverCompilerAdapter[0].getClass().getComponentType();
        }
        javac.setCompiler(clazz.getName());
        if (origCompiler != null) {
            this.getConfigForProject(javac.getProject()).setCompilerDelegate(origCompiler);
        }
        this.instrumentationOccured = true;
    }

    private void injectClover(AntInstrumentationConfig cfg, JUnitTask junit) {
        Vector batchTests;
        Vector individualTests;
        junit.createClasspath().add(new Path(junit.getProject(), ClassPathUtil.getCloverJarPath()));
        try {
            Field individualTestsField = junit.getClass().getDeclaredField("tests");
            Field batchTestsField = junit.getClass().getDeclaredField("batchTests");
            individualTestsField.setAccessible(true);
            batchTestsField.setAccessible(true);
            individualTests = (Vector)individualTestsField.get(junit);
            batchTests = (Vector)batchTestsField.get(junit);
            Logger.getInstance().debug(new StringBuffer().append("batchTests.size() = ").append(batchTests.size()).toString());
            Logger.getInstance().debug(new StringBuffer().append("individualTests.size() = ").append(individualTests.size()).toString());
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        List<OptimizableJUnitTest> wrappedTests = this.getIndividualWrappedTests(batchTests, individualTests);
        this.unitTestingOccured = true;
        try {
            wrappedTests = LocalSnapshotOptimizer.optimize(wrappedTests, this.optimizationOptions);
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when optimizing tests", e);
            Logger.getInstance().error("Optimization failed. Running all specified tests.");
            return;
        }
        individualTests.clear();
        batchTests.clear();
        for (OptimizableJUnitTest test : wrappedTests) {
            individualTests.add(test.getJUnitTest());
        }
    }

    private List<OptimizableJUnitTest> getIndividualWrappedTests(Vector batchTests, Vector individualTests) {
        ArrayList<OptimizableJUnitTest> wrappedTests = new ArrayList<OptimizableJUnitTest>();
        for (BatchTest batchTest : batchTests) {
            Enumeration test = batchTest.elements();
            while (test.hasMoreElements()) {
                wrappedTests.add(new OptimizableJUnitTest((JUnitTest)test.nextElement()));
            }
        }
        for (JUnitTest test : individualTests) {
            wrappedTests.add(new OptimizableJUnitTest(test));
        }
        return wrappedTests;
    }

    private static class OptimizableJUnitTest
    implements Optimizable {
        private JUnitTest test;

        public OptimizableJUnitTest(JUnitTest test) {
            this.test = test;
        }

        public String getName() {
            return this.test.getName();
        }

        public JUnitTest getJUnitTest() {
            return this.test;
        }
    }
}

