/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.spec.instr.test;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.instr.AggregateTestDetector;
import com.cenqua.clover.instr.BooleanStrategy;
import com.cenqua.clover.instr.DefaultTestDetector;
import com.cenqua.clover.instr.OrStrategy;
import com.cenqua.clover.instr.TestDetector;
import com.cenqua.clover.instr.TestSpec;
import com.cenqua.clover.spec.instr.test.TestClassSpec;
import com.cenqua.clover.spec.instr.test.TestMethodSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BooleanSpec {
    private List testClassSpecs = null;

    public void addConfiguredTestClass(TestClassSpec testClassSpec) {
        if (this.testClassSpecs == null) {
            this.testClassSpecs = new ArrayList();
        }
        this.testClassSpecs.add(testClassSpec);
    }

    public List getTestClassSpecs() {
        return this.testClassSpecs;
    }

    public abstract BooleanStrategy getStrategy();

    public static TestDetector buildTestDetectorFor(List boolSpecs) throws CloverException {
        if (boolSpecs != null) {
            AggregateTestDetector testDetectorGroups = new AggregateTestDetector(new OrStrategy());
            Iterator i = boolSpecs.iterator();
            while (i.hasNext()) {
                BooleanSpec booleanSpec = (BooleanSpec)i.next();
                if (booleanSpec.getTestClassSpecs() == null) continue;
                AggregateTestDetector testDetectors = new AggregateTestDetector(booleanSpec.getStrategy());
                Iterator iterator = booleanSpec.getTestClassSpecs().iterator();
                while (iterator.hasNext()) {
                    TestClassSpec testClassSpec = (TestClassSpec)iterator.next();
                    TestSpec testSpec = new TestSpec();
                    try {
                        if (testClassSpec.getPackage() != null) {
                            testSpec.setPkgPattern(Pattern.compile(testClassSpec.getPackage()));
                        }
                        if (testClassSpec.getAnnotation() != null) {
                            testSpec.setClassAnnotationPattern(Pattern.compile(testClassSpec.getAnnotation()));
                        }
                        if (testClassSpec.getTag() != null) {
                            testSpec.setClassTagPattern(Pattern.compile(testClassSpec.getTag()));
                        }
                        if (testClassSpec.getName() != null) {
                            testSpec.setClassPattern(Pattern.compile(testClassSpec.getName()));
                        }
                        if (testClassSpec.getSuper() != null) {
                            testSpec.setSuperPattern(Pattern.compile(testClassSpec.getSuper()));
                        }
                        List methodSpecs = testClassSpec.getTestMethods();
                        AggregateTestDetector methodDetectors = new AggregateTestDetector(new OrStrategy());
                        Iterator iterator1 = methodSpecs.iterator();
                        while (iterator1.hasNext()) {
                            TestSpec method = new TestSpec(testSpec);
                            TestMethodSpec methodSpec = (TestMethodSpec)iterator1.next();
                            if (methodSpec.getAnnotation() != null) {
                                method.setMethodAnnotationPattern(Pattern.compile(methodSpec.getAnnotation()));
                            }
                            if (methodSpec.getTag() != null) {
                                method.setMethodTagPattern(Pattern.compile(methodSpec.getTag()));
                            }
                            if (methodSpec.getName() != null) {
                                method.setMethodPattern(Pattern.compile(methodSpec.getName()));
                            }
                            if (methodSpec.getReturnType() != null) {
                                method.setMethodReturnTypePattern(Pattern.compile(methodSpec.getReturnType()));
                            }
                            methodDetectors.addDetector(method);
                        }
                        if (!methodDetectors.isEmpty()) {
                            testDetectors.addDetector(methodDetectors);
                            continue;
                        }
                        testDetectors.addDetector(testSpec);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Error parsing regular expression: " + e.getMessage());
                    }
                }
                testDetectorGroups.addDetector(testDetectors);
            }
            return testDetectorGroups;
        }
        return new DefaultTestDetector();
    }
}

