/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.types;

import com.cenqua.clover.DefaultLogger;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.types.BaseCloverOptimizedTestSelector;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.ExtendFileSelector;

public class CloverOptimizedTestSelectorForAnt153
extends BaseCloverOptimizedTestSelector
implements ExtendFileSelector {
    private String initString;
    private final DefaultLogger LOG = new DefaultLogger(){

        public void log(int level, String msg, Throwable t) {
            if (!CloverOptimizedTestSelectorForAnt153.this.options.isDebug() && level <= 3) {
                return;
            }
            System.out.println("    [clover] " + msg);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    };

    public void init(Project proj) {
        System.out.println("proj = " + proj);
    }

    protected Logger takeOverLogging(Project project) {
        Logger origLog = Logger.getInstance();
        Logger.setInstance(this.LOG);
        return origLog;
    }

    public void setParameters(Parameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.getName().equalsIgnoreCase("snapshotfile")) {
                this.setSnapshotFile(new File(parameter.getValue()));
                continue;
            }
            if (parameter.getName().equalsIgnoreCase("debug")) {
                this.options.debug(Boolean.valueOf(parameter.getValue() == null ? null : parameter.getValue().toLowerCase()) != false || "on".equalsIgnoreCase(parameter.getValue()) || "yes".equalsIgnoreCase(parameter.getValue()));
                continue;
            }
            if (parameter.getName().equalsIgnoreCase("initstring")) {
                this.initString = parameter.getValue();
                continue;
            }
            if (parameter.getName().equalsIgnoreCase("fullRunEvery")) {
                this.options.maxCompilesBeforeStaleSnapshot(Integer.parseInt(parameter.getValue()));
                continue;
            }
            Logger.getInstance().info("Unknown parameter: " + parameter.getName());
        }
    }

    protected AntInstrumentationConfig getInstrConfig() {
        Project project = this.getProject();
        if (project == null) {
            project = new Project();
            project.setName("clover-project");
        }
        AntInstrumentationConfig config = new AntInstrumentationConfig(project);
        config.setInitstring(this.initString);
        return config;
    }
}

