/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import com.cenqua.clover.AntLogger;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Contract;
import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.FileMappedTestDetector;
import com.cenqua.clover.instr.Instrumenter;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.tasks.TestSourceSet;
import com.cenqua.clover.util.ClassPathUtil;
import com.cenqua.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class CloverCompilerAdapter
implements CompilerAdapter {
    private Logger log;
    private String compilerDelegate;
    private Javac javac;
    private CompilerAdapter underlyingCompiler;
    private Project project;
    private CloverException error;
    private String javacName;
    private File tmpDir;
    private boolean preserveInstr;
    private CompilerVersionFiddler compilerVersionFiddler = new CompilerVersionFiddler();

    private void cloverLogging() {
        this.javacName = this.javac.getTaskName();
        this.javac.setTaskName("clover");
    }

    private void javacLogging() {
        this.javac.setTaskName(this.javacName);
    }

    public void setJavac(Javac aJavac) {
        Contract.pre(aJavac != null);
        this.javac = aJavac;
        this.project = this.javac.getProject();
        Logger.setInstance(new AntLogger(this.project, (Task)this.javac));
        this.log = Logger.getInstance();
        this.cloverLogging();
        CloverStartup.loadLicense(this.log);
        if (this.javac.getDestdir() == null) {
            this.error = new CloverException("When using Clover you need to set the destdir on <javac>");
            return;
        }
        AntInstrumentationConfig instrConfig = (AntInstrumentationConfig)this.project.getReference("clover.config");
        if (instrConfig == null) {
            instrConfig = new AntInstrumentationConfig(this.project);
        }
        this.compilerDelegate = instrConfig.getCompilerDelegate();
        this.preserveInstr = instrConfig.isPreserve();
        if (this.javac.isForkedJavac()) {
            this.log.info("Fork is set to true and will be respected (ignore any warnings from Ant).");
            if (this.compilerDelegate != null && !"extJavac".equals(this.compilerDelegate)) {
                this.log.warn("Ignoring clover.compiler setting because fork is true. Using 'extJavac' compiler.");
            }
            this.compilerDelegate = "extJavac";
        }
        if (this.compilerDelegate != null && this.compilerDelegate.equals(this.getClass().getName())) {
            this.error = new CloverException("You cannot set clover.compiler to be the Clover Compiler Adapter. Check the value you are passing to clover.compiler");
            return;
        }
        if (this.compilerDelegate == null) {
            this.compilerDelegate = CloverCompilerAdapter.getDefaultAntCompiler();
        }
        this.log.debug("using underlying compiler '" + this.compilerDelegate + "'");
        this.underlyingCompiler = CompilerAdapterFactory.getCompiler((String)this.compilerDelegate, (Task)this.javac);
        this.log.debug("underlying compiler instance is " + this.underlyingCompiler.getClass().getName());
        if (instrConfig.isEnabled()) {
            DirectoryScanner ds;
            Object instrPatternSetRef;
            String encoding;
            String src = this.javac.getSource();
            if (src != null) {
                instrConfig.setSourceLevel(src);
            }
            if ((encoding = this.javac.getEncoding()) != null) {
                instrConfig.setEncoding(this.javac.getEncoding());
            }
            String includes = this.getProp("clover.includes", "");
            String excludes = this.getProp("clover.excludes", "");
            PatternSet instrPatternSet = null;
            if (includes.length() > 0 || excludes.length() > 0) {
                instrPatternSet = new PatternSet();
                if (includes.length() > 0) {
                    instrPatternSet.setIncludes(includes);
                } else {
                    instrPatternSet.setIncludes("**");
                }
                if (excludes.length() > 0) {
                    instrPatternSet.setExcludes(excludes);
                }
            }
            if ((instrPatternSetRef = this.project.getReferences().get("clover.files")) != null && instrPatternSetRef instanceof PatternSet) {
                if (instrPatternSet != null) {
                    this.log.warn("Sub-element <files> of <clover-setup> overrides clover.includes/excludes properties.");
                }
                instrPatternSet = (PatternSet)instrPatternSetRef;
            }
            Object instrFileSetsRef = this.project.getReferences().get("clover.filesets");
            List instrFileSetsList = null;
            if (instrFileSetsRef != null && instrFileSetsRef instanceof List) {
                instrFileSetsList = (List)instrFileSetsRef;
            }
            String[] srcDirs = this.javac.getSrcdir().list();
            HashSet<File> compileSet = new HashSet<File>();
            compileSet.addAll(Arrays.asList(this.javac.compileList));
            HashSet<File> copySet = new HashSet<File>(compileSet);
            HashSet<File> instrSet = new HashSet<File>();
            if (instrFileSetsList == null && instrPatternSet == null) {
                copySet.clear();
                instrSet.addAll(compileSet);
            } else if (instrPatternSet != null) {
                for (int i = 0; i < srcDirs.length; ++i) {
                    String srcDir = srcDirs[i];
                    ds = new DirectoryScanner();
                    ds.setBasedir(srcDir);
                    ds.setIncludes(instrPatternSet.getIncludePatterns(this.project));
                    ds.setExcludes(instrPatternSet.getExcludePatterns(this.project));
                    ds.scan();
                    String[] included = ds.getIncludedFiles();
                    for (int j = 0; j < included.length; ++j) {
                        File inc = new File(srcDir, included[j]);
                        if (!compileSet.contains(inc)) continue;
                        instrSet.add(inc);
                        copySet.remove(inc);
                    }
                    String[] excluded = ds.getExcludedFiles();
                    for (int j = 0; j < excluded.length; ++j) {
                        File exc = new File(srcDir, excluded[j]);
                        if (!compileSet.contains(exc)) continue;
                        instrSet.remove(exc);
                        copySet.add(exc);
                    }
                }
            } else if (instrFileSetsList != null) {
                Iterator fs = instrFileSetsList.iterator();
                while (fs.hasNext()) {
                    FileSet fileSet = (FileSet)fs.next();
                    ds = fileSet.getDirectoryScanner(this.project);
                    File baseDir = fileSet.getDir(this.project);
                    String[] included = ds.getIncludedFiles();
                    for (int j = 0; j < included.length; ++j) {
                        File inc = new File(baseDir, included[j]);
                        if (!compileSet.contains(inc)) continue;
                        instrSet.add(inc);
                        copySet.remove(inc);
                    }
                    String[] excluded = ds.getExcludedFiles();
                    for (int j = 0; j < excluded.length; ++j) {
                        File exc = new File(baseDir, excluded[j]);
                        if (!compileSet.contains(exc)) continue;
                        instrSet.remove(exc);
                        copySet.add(exc);
                    }
                }
            }
            Object testSourcesRef = this.project.getReferences().get("clover.testfilesets");
            if (testSourcesRef != null && testSourcesRef instanceof List) {
                FileMappedTestDetector fileMappedTestDetector = new FileMappedTestDetector();
                List testSourcesList = (List)testSourcesRef;
                Iterator ts = testSourcesList.iterator();
                while (ts.hasNext()) {
                    TestSourceSet testSourceSet = (TestSourceSet)ts.next();
                    Set included = testSourceSet.getIncludedFiles();
                    Iterator incFile = included.iterator();
                    while (incFile.hasNext()) {
                        File inc = (File)incFile.next();
                        if (!compileSet.contains(inc)) continue;
                        instrSet.add(inc);
                        copySet.remove(inc);
                    }
                    Set excluded = testSourceSet.getExcludedFiles();
                    Iterator excFile = excluded.iterator();
                    while (excFile.hasNext()) {
                        File exc = (File)excFile.next();
                        if (!compileSet.contains(exc)) continue;
                        instrSet.remove(exc);
                        copySet.add(exc);
                    }
                    fileMappedTestDetector.addTestSourceMatcher(testSourceSet);
                }
                instrConfig.setTestDetector(fileMappedTestDetector);
            }
            HashSet<File> replacementCompileSet = new HashSet<File>();
            replacementCompileSet.addAll(copySet);
            try {
                this.createInstrDir(instrConfig.getTmpDir());
                Instrumenter instrumenter = new Instrumenter(this.log, instrConfig);
                instrumenter.startInstrumentation();
                Iterator inc = instrSet.iterator();
                while (inc.hasNext()) {
                    File f = (File)inc.next();
                    File copy = instrumenter.instrument(f, this.tmpDir);
                    replacementCompileSet.add(copy);
                }
                instrumenter.endInstrumentation();
                this.javac.compileList = replacementCompileSet.toArray(new File[replacementCompileSet.size()]);
            }
            catch (CloverException e) {
                this.error = e;
                this.log.error(this.error.getMessage());
                this.log.error("** Error(s) occurred and the instrumentation process can't continue.");
                this.cleanUpInstrDir();
            }
            String cloverPathStr = ClassPathUtil.getCloverJarPath();
            if (cloverPathStr != null) {
                Path cloverPath = new Path(this.project, cloverPathStr);
                this.javac.setClasspath(cloverPath);
            }
        } else {
            this.log.info("** Clover is disabled. Delegating straight to the compiler.");
        }
        this.compilerVersionFiddler.push();
        this.underlyingCompiler.setJavac(this.javac);
        this.compilerVersionFiddler.pop();
        this.javacLogging();
    }

    public static String getDefaultAntCompiler() {
        if (Project.getJavaVersion() != "1.1" && Project.getJavaVersion() != "1.2") {
            return "modern";
        }
        return "classic";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws BuildException {
        this.cloverLogging();
        if (this.error != null) {
            Throwable cause = this.error;
            if (this.error.getException() != null) {
                cause = this.error.getException();
            }
            throw new BuildException(cause);
        }
        try {
            this.log.debug("delegating to compiler impl: " + this.underlyingCompiler.getClass().getName());
            this.javacLogging();
            this.compilerVersionFiddler.push();
            boolean retval = this.underlyingCompiler.execute();
            this.compilerVersionFiddler.pop();
            boolean bl = retval;
            return bl;
        }
        finally {
            this.cloverLogging();
            this.cleanUpInstrDir();
            this.javacLogging();
        }
    }

    private void createInstrDir(File basedir) throws CloverException {
        try {
            if (basedir != null) {
                if (!basedir.isDirectory() && !basedir.mkdirs()) {
                    throw new CloverException("Failed to create temp directory '" + basedir + "'");
                }
                this.tmpDir = File.createTempFile("clover", null, basedir);
            } else {
                this.tmpDir = File.createTempFile("clover", null);
            }
            this.tmpDir.delete();
            if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
                throw new CloverException("Failed to create temp directory");
            }
        }
        catch (IOException e) {
            throw new CloverException("Failed to create temp directory");
        }
    }

    private void cleanUpInstrDir() {
        if (!this.preserveInstr && this.tmpDir != null) {
            FileUtils.deltree(this.tmpDir);
        }
    }

    private String getProp(String key, String defaultValue) {
        Contract.pre(key != null);
        String prop = this.project.getProperty(key);
        if (prop == null) {
            prop = defaultValue;
        }
        return prop;
    }

    class CompilerVersionFiddler {
        private String ourCompilerStr = null;

        CompilerVersionFiddler() {
        }

        void push() {
            try {
                this.ourCompilerStr = CloverCompilerAdapter.this.javac.getCompilerVersion();
                CloverCompilerAdapter.this.javac.setCompiler(CloverCompilerAdapter.this.compilerDelegate);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        void pop() {
            if (this.ourCompilerStr != null) {
                try {
                    CloverCompilerAdapter.this.javac.setCompiler(this.ourCompilerStr);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            this.ourCompilerStr = null;
        }
    }
}

