/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Library;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class AnnotatedLibraryTest
extends TestCase {
    public void testProxyMethodHasAnnotations() throws Exception {
        AnnotatedLibrary a = (AnnotatedLibrary)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{AnnotatedLibrary.class}, (InvocationHandler)new TestInvocationHandler());
        AnnotatedLibraryTest.assertTrue((String)"Proxy method not annotated", (boolean)a.isAnnotated());
    }

    public void testAnnotationsOnMethods() throws Exception {
        int MAGIC = -1410478301;
        HashMap<String, DefaultTypeMapper> options = new HashMap<String, DefaultTypeMapper>();
        final boolean[] hasAnnotation = new boolean[]{false, false};
        DefaultTypeMapper mapper = new DefaultTypeMapper();
        mapper.addTypeConverter(Boolean.class, new TypeConverter(){

            public Object toNative(Object value, ToNativeContext ctx) {
                MethodParameterContext mcontext = (MethodParameterContext)ctx;
                hasAnnotation[0] = mcontext.getMethod().getAnnotation(FooBoolean.class) != null;
                return new Integer(Boolean.TRUE.equals(value) ? -1410478301 : 0);
            }

            public Object fromNative(Object value, FromNativeContext context) {
                MethodResultContext mcontext = (MethodResultContext)context;
                hasAnnotation[1] = mcontext.getMethod().getAnnotation(FooBoolean.class) != null;
                return (Integer)value == -1410478301;
            }

            public Class nativeType() {
                return Integer.class;
            }
        });
        options.put("type-mapper", mapper);
        AnnotationTestLibrary lib = (AnnotationTestLibrary)Native.loadLibrary((String)"testlib", AnnotationTestLibrary.class, options);
        AnnotatedLibraryTest.assertEquals((String)"Failed to convert integer return to boolean TRUE", (boolean)true, (boolean)lib.returnInt32Argument(true));
        AnnotatedLibraryTest.assertTrue((String)"Failed to get annotation from ParameterContext", (boolean)hasAnnotation[0]);
        AnnotatedLibraryTest.assertTrue((String)"Failed to get annotation from ResultContext", (boolean)hasAnnotation[1]);
    }

    public static void main(String[] args) {
        TestRunner.run(AnnotatedLibraryTest.class);
    }

    public static interface AnnotationTestLibrary
    extends Library {
        @FooBoolean
        public boolean returnInt32Argument(boolean var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FooBoolean {
    }

    public class TestInvocationHandler
    implements InvocationHandler {
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.getAnnotations().length == 1;
        }
    }

    public static interface AnnotatedLibrary
    extends Library {
        @TestAnnotation
        public boolean isAnnotated();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
    }
}

