/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class PointerBufferTest
extends TestCase {
    public void testByteBufferPutString() {
        String MAGIC = "magic";
        Memory m = new Memory(1024L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        buf.put("magic".getBytes()).put((byte)0).flip();
        PointerBufferTest.assertEquals((String)"String not written to memory", (String)"magic", (String)m.getString(0L, false));
    }

    public void testByteBufferPutByte() {
        int MAGIC = -19;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        buf.put((byte)-19).flip();
        PointerBufferTest.assertEquals((String)"Byte not written to memory", (byte)-19, (byte)m.getByte(0L));
    }

    public void testByteBufferPutInt() {
        int MAGIC = -1410478301;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        buf.putInt(-1410478301).flip();
        PointerBufferTest.assertEquals((String)"Int not written to memory", (int)-1410478301, (int)m.getInt(0L));
    }

    public void testByteBufferPutLong() {
        long MAGIC = 1311768467139281697L;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        buf.putLong(1311768467139281697L).flip();
        PointerBufferTest.assertEquals((String)"Long not written to memory", (long)1311768467139281697L, (long)m.getLong(0L));
    }

    public void testByteBufferGetByte() {
        int MAGIC = -19;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        m.setByte(0L, (byte)-19);
        PointerBufferTest.assertEquals((String)"Byte not read from memory", (byte)-19, (byte)buf.get(0));
    }

    public void testByteBufferGetInt() {
        int MAGIC = -1410478301;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        m.setInt(0L, -1410478301);
        PointerBufferTest.assertEquals((String)"Int not read from memory", (int)-1410478301, (int)buf.getInt(0));
    }

    public void testByteBufferGetLong() {
        long MAGIC = 1311768467139281697L;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        m.setLong(0L, 1311768467139281697L);
        PointerBufferTest.assertEquals((String)"Long not read from memory", (long)1311768467139281697L, (long)buf.getLong(0));
    }

    public void testIntBufferPut() {
        int MAGIC = -1410478301;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        IntBuffer ib = buf.asIntBuffer();
        ib.put(-1410478301).flip();
        PointerBufferTest.assertEquals((String)"Int not written to memory", (int)-1410478301, (int)m.getInt(0L));
    }

    public void testLongBufferPut() {
        long MAGIC = 1311768467139281697L;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        LongBuffer lb = buf.asLongBuffer();
        lb.put(1311768467139281697L).flip();
        PointerBufferTest.assertEquals((String)"Long not written to memory", (long)1311768467139281697L, (long)m.getLong(0L));
    }

    public void testFloatBufferPut() {
        float MAGIC = 1234.5677f;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        FloatBuffer fb = buf.asFloatBuffer();
        fb.put(1234.5677f).flip();
        PointerBufferTest.assertEquals((String)"Int not written to memory", (float)1234.5677f, (float)m.getFloat(0L), (float)0.0f);
    }

    public void testDoubleBufferPut() {
        double MAGIC = 1234.5678;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        DoubleBuffer db = buf.asDoubleBuffer();
        db.put(1234.5678).flip();
        PointerBufferTest.assertEquals((String)"Int not written to memory", (double)1234.5678, (double)m.getDouble(0L), (double)0.0);
    }

    public void testIntBufferGet() {
        int MAGIC = -1410478301;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        IntBuffer ib = buf.asIntBuffer();
        m.setInt(0L, -1410478301);
        PointerBufferTest.assertEquals((String)"Int not read from memory", (int)-1410478301, (int)ib.get(0));
    }

    public void testLongBufferGet() {
        long MAGIC = 1311768467139281697L;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        LongBuffer lb = buf.asLongBuffer();
        m.setLong(0L, 1311768467139281697L);
        PointerBufferTest.assertEquals((String)"Long not read from memory", (long)1311768467139281697L, (long)lb.get(0));
    }

    public void testFloatBufferGet() {
        float MAGIC = 1234.5677f;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        FloatBuffer fb = buf.asFloatBuffer();
        m.setFloat(0L, 1234.5677f);
        PointerBufferTest.assertEquals((String)"Float not read from memory", (float)1234.5677f, (float)fb.get(0), (float)0.0f);
    }

    public void testDoubleBufferGet() {
        double MAGIC = 1234.5678;
        Memory m = new Memory(8L);
        ByteBuffer buf = m.getByteBuffer(0L, m.size()).order(ByteOrder.nativeOrder());
        DoubleBuffer db = buf.asDoubleBuffer();
        m.setDouble(0L, 1234.5678);
        PointerBufferTest.assertEquals((String)"Double not read from memory", (double)1234.5678, (double)db.get(0), (double)0.0);
    }

    public void testDirectBufferPointer() throws Exception {
        Memory p = new Memory(1024L);
        ByteBuffer b = p.getByteBuffer(0L, 1024L);
        PointerBufferTest.assertEquals((String)"ByteBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b));
        PointerBufferTest.assertEquals((String)"ShortBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b.asShortBuffer()));
        PointerBufferTest.assertEquals((String)"IntBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b.asIntBuffer()));
        PointerBufferTest.assertEquals((String)"LongBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b.asLongBuffer()));
        PointerBufferTest.assertEquals((String)"FloatBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b.asFloatBuffer()));
        PointerBufferTest.assertEquals((String)"DoubleBuffer Pointer does not match", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b.asDoubleBuffer()));
        PointerBufferTest.assertEquals((String)"Wrong direct buffer address", (Object)p, (Object)Native.getDirectBufferPointer((Buffer)b));
    }

    public static void main(String[] args) {
        TestRunner.run(PointerBufferTest.class);
    }
}

