/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.textui.TestRunner;

public class WebStartTest
extends TestCase {
    private static final String POLICY = "grant { \n permission java.security.AllPermission;\n};";
    private static final String JNLP = "<?xml version='1.0' encoding='UTF-8'?>\n<jnlp spec='1.0' codebase='{CODEBASE}' href='{JNLP_FILE}'>\n  <information>\n    <title>JNLP Web Start Test</title>\n    <vendor>JNA</vendor>\n    <homepage href='http://github.com/twall/jna'/>\n    <description>Local JNLP launch test.</description>\n    <description kind='short'>Launch Test</description>\n  </information>\n  <security><all-permissions/></security>\n  <resources>\n    <j2se version='1.4+' java-vm-args='-Djavawebstart.version=0.0'/>\n    <jar href='jna-test.jar'/>\n    <jar href='jna.jar'/>\n    <jar href='junit.jar'/>{CLOVER}\n    <nativelib href='jnidispatch.jar'/>\n  </resources>\n  <offline-allowed/>\n  <application-desc main-class='" + WebStartTest.class.getName() + "'>\n" + "    <argument>{CLASS}</argument>\n" + "    <argument>{METHOD}</argument>\n" + "    <argument>{PORT}</argument>\n" + "    <argument>javawebstart</argument>\n" + "  </application-desc>\n" + "</jnlp>";
    private static final String FAILURE = "This test is supposed to fail";
    private static final String ERROR = "This test is supposed to error";
    private static final String POLICY_KEY = "deployment.user.security.policy";
    private static final String CERTS_KEY = "deployment.user.security.trusted.certs";

    public void testLaunchedUnderWebStart() throws Exception {
        WebStartTest.assertNotNull((String)"Test not launched under web start", (Object)System.getProperty("javawebstart.version"));
    }

    public void testDetectFailure() {
        WebStartTest.fail((String)FAILURE);
    }

    public void testDetectError() {
        throw new Error(ERROR);
    }

    public void testJNLPFindCustomLibrary() {
        WebStartTest.assertNotNull((String)"Custom library path not found by JNLP class loader", (Object)Native.getWebStartLibraryPath((String)"jnidispatch"));
        Native.loadLibrary((String)"jnidispatch", Dummy.class);
    }

    public void testJNLPFindProcessLibrary() {
        String libname = Platform.C_LIBRARY_NAME;
        WebStartTest.assertNull((String)"Process library path not expected to be found by JNLP class loader", (Object)Native.getWebStartLibraryPath((String)libname));
        Native.loadLibrary((String)libname, Dummy.class);
    }

    public void testJNLPFindLibraryFailure() {
        try {
            Native.loadLibrary((String)"xyzzy", Dummy.class);
            WebStartTest.fail((String)"Missing native libraries should throw UnsatisfiedLinkError");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestUnderWebStart(String testClass, String testMethod) throws Exception {
        String BUILDDIR = System.getProperty("jna.builddir", "build" + (Platform.is64Bit() ? "-d64" : ""));
        String codebase = new File(BUILDDIR, "jws").toURI().toURL().toString();
        ServerSocket s = new ServerSocket(0);
        s.setSoTimeout(120000);
        int port = s.getLocalPort();
        File jnlp = File.createTempFile(this.getName(), ".jnlp");
        String contents = JNLP.replace("{CLASS}", testClass);
        contents = contents.replace("{METHOD}", testMethod);
        contents = contents.replace("{CODEBASE}", codebase);
        contents = contents.replace("{JNLP_FILE}", jnlp.toURI().toURL().toString());
        contents = contents.replace("{PORT}", String.valueOf(port));
        boolean clover = System.getProperty("java.class.path").indexOf("clover") != -1;
        contents = contents.replace("{CLOVER}", clover ? "<jar href='clover.jar'/>" : "");
        try {
            FileOutputStream os = new FileOutputStream(jnlp);
            ((OutputStream)os).write(contents.getBytes());
            ((OutputStream)os).close();
            String path = this.findJWS();
            String[] cmd = new String[]{path, "-Xnosplash", "-wait", jnlp.toURI().toURL().toString()};
            Process p = Runtime.getRuntime().exec(cmd);
            StringBuffer output = new StringBuffer();
            class SocketHandler
            extends Thread {
                private InputStream is;
                private StringBuffer sb;

                public SocketHandler(Socket s, StringBuffer b) throws IOException {
                    this.is = s.getInputStream();
                    this.sb = b;
                }

                public void run() {
                    byte[] buf = new byte[256];
                    block6: while (true) {
                        try {
                            int count;
                            while ((count = this.is.read(buf, 0, buf.length)) != -1) {
                                if (count == 0) {
                                    try {
                                        SocketHandler.sleep(1L);
                                        continue block6;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                }
                                this.sb.append(new String(buf, 0, count));
                            }
                        }
                        catch (IOException e) {
                            WebStartTest.showMessage("read error: " + e.toString());
                            continue;
                        }
                        break;
                    }
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            SocketHandler out = null;
            try {
                out = new SocketHandler(s.accept(), output);
                out.start();
            }
            catch (SocketTimeoutException e) {
                try {
                    p.exitValue();
                }
                catch (IllegalThreadStateException e2) {
                    p.destroy();
                    throw new Error("JWS Timed out");
                }
            }
            p.waitFor();
            if (out != null) {
                out.join();
            }
            int code = p.exitValue();
            String error = output.toString();
            if (code != 0 || !"".equals(error)) {
                if (code == 1 || error.indexOf("AssertionFailedError") != -1) {
                    WebStartTest.fail((String)("JWS FAIL: " + error));
                }
                throw new Error("JWS ERROR: " + error);
            }
        }
        finally {
            jnlp.delete();
        }
    }

    private static boolean runningWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }

    private void runTestUnderWebStart() throws Exception {
        if (((Object)((Object)this)).getClass().equals(WebStartTest.class)) {
            if (this.getName().equals("testDetectFailure")) {
                block12: {
                    try {
                        this.runTestUnderWebStart(((Object)((Object)this)).getClass().getName(), this.getName());
                    }
                    catch (AssertionFailedError e) {
                        if (e.getMessage().indexOf(FAILURE) == -1) break block12;
                        return;
                    }
                }
                WebStartTest.fail((String)"Failed to detect test failure");
            } else if (this.getName().equals("testDetectError")) {
                try {
                    this.runTestUnderWebStart(((Object)((Object)this)).getClass().getName(), this.getName());
                }
                catch (AssertionFailedError e) {
                    WebStartTest.fail((String)("Test produced a failure instead of an error: " + (Object)((Object)e)));
                }
                catch (Error e) {
                    if (e.getMessage().indexOf(ERROR) != -1) {
                        return;
                    }
                    throw e;
                }
                WebStartTest.fail((String)"Failed to detect test error");
            } else {
                this.runTestUnderWebStart(((Object)((Object)this)).getClass().getName(), this.getName());
            }
        } else {
            this.runTestUnderWebStart(((Object)((Object)this)).getClass().getName(), this.getName());
        }
    }

    private String findJWS() throws IOException {
        String JAVA_HOME = System.getProperty("java.home");
        String BIN = new File(JAVA_HOME, "/bin").getAbsolutePath();
        File javaws = new File(BIN, "javaws" + (Platform.isWindows() ? ".exe" : ""));
        if (!javaws.exists()) {
            if (Platform.isMac()) {
                javaws = new File(JAVA_HOME, "../Commands/javaws");
            }
            if (Platform.isWindows()) {
                FolderInfo info = (FolderInfo)Native.loadLibrary((String)"shell32", FolderInfo.class);
                char[] buf = new char[260];
                info.SHGetFolderPathW(null, 36, null, 0, buf);
                String path = Native.toString((char[])buf);
                javaws = Platform.is64Bit() ? new File(path, "SysWOW64/javaws.exe") : new File(path, "system32/javaws.exe");
            }
            if (!javaws.exists()) {
                throw new IOException("javaws executable not found");
            }
        }
        return javaws.getAbsolutePath();
    }

    private File findDeploymentProperties() {
        File deployment;
        String path = System.getProperty("user.home");
        if (Platform.isWindows()) {
            FolderInfo info = (FolderInfo)Native.loadLibrary((String)"shell32", FolderInfo.class);
            char[] buf = new char[260];
            info.SHGetFolderPathW(null, 26, null, 0, buf);
            path = Native.toString((char[])buf);
            String vendor = System.getProperty("java.vm.vendor");
            if (vendor.indexOf(" ") != -1) {
                vendor = vendor.substring(0, vendor.indexOf(" "));
            }
            if ("Oracle".equals(vendor)) {
                vendor = "Sun";
            }
            if (!(deployment = new File(path + "/" + vendor + "/Java/Deployment")).exists()) {
                deployment = new File(deployment.getAbsolutePath().replace("Local", "LocalLow").replace("Roaming", "LocalLow"));
            }
        } else {
            deployment = Platform.isMac() ? new File(path + "/Library/Caches/Java") : new File(path + "/.java/deployment");
        }
        if (!deployment.exists()) {
            throw new Error("The user deployment directory " + deployment + " does not exist; save Java Control Panel or Web Start settings to initialize it");
        }
        return new File(deployment, "deployment.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        if (WebStartTest.runningWebStart()) {
            super.runBare();
        } else if (!GraphicsEnvironment.isHeadless()) {
            File policy = File.createTempFile(this.getName(), ".policy");
            FileOutputStream os = new FileOutputStream(policy);
            ((OutputStream)os).write(POLICY.getBytes());
            ((OutputStream)os).close();
            File dpfile = this.findDeploymentProperties();
            Properties saved = new Properties();
            saved.load(new FileInputStream(dpfile));
            Properties props = new Properties();
            props.putAll((Map<?, ?>)saved);
            props.setProperty(CERTS_KEY, new File("jna.keystore").getAbsolutePath());
            props.setProperty(POLICY_KEY, policy.getAbsolutePath());
            os = new FileOutputStream(dpfile);
            props.store(os, "deployment.properties (for testing)");
            ((OutputStream)os).close();
            try {
                this.runTestUnderWebStart();
            }
            finally {
                policy.delete();
                os = new FileOutputStream(dpfile);
                saved.store(os, "deployment.properties");
                ((OutputStream)os).close();
            }
        }
    }

    private static void runTestCaseTest(String testClass, String method, int port) {
        try {
            TestCase test = (TestCase)Class.forName(testClass).newInstance();
            test.setName(method);
            TestResult result = new TestResult();
            test.run(result);
            Socket s = new Socket(InetAddress.getLocalHost(), port);
            OutputStream os = s.getOutputStream();
            if (result.failureCount() != 0) {
                Enumeration e = result.failures();
                Throwable t = ((TestFailure)e.nextElement()).thrownException();
                t.printStackTrace(new PrintStream(os));
            } else if (result.errorCount() != 0) {
                Enumeration e = result.errors();
                Throwable t = ((TestFailure)e.nextElement()).thrownException();
                t.printStackTrace(new PrintStream(os));
            }
            s.close();
            System.exit(0);
        }
        catch (Throwable e) {
            WebStartTest.showMessage("ERROR: " + e.getMessage());
            System.exit(0);
        }
    }

    private static void showMessage(String msg) {
        WebStartTest.showMessage(msg, 60000);
    }

    private static void showMessage(String msg, int timeout) {
        JFrame f = new JFrame("Web Start Test Failure");
        f.getContentPane().add(new JScrollPane(new JLabel(msg)));
        f.pack();
        f.setLocation(100, 100);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        if (timeout != 0) {
            try {
                Thread.sleep(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 4 && "javawebstart".equals(args[3]) && !WebStartTest.runningWebStart()) {
                System.setProperty("javawebstart.version", "fake");
            }
            if (WebStartTest.runningWebStart()) {
                String testClass = args.length > 0 ? args[0] : WebStartTest.class.getName();
                String testMethod = args.length > 1 ? args[1] : "testLaunchedUnderWebStart";
                int port = args.length > 2 ? Integer.parseInt(args[2]) : 8080;
                WebStartTest.runTestCaseTest(testClass, testMethod, port);
            } else {
                TestRunner.run(WebStartTest.class);
            }
        }
        catch (Throwable t) {
            WebStartTest.showMessage("ERROR: " + t.getMessage());
        }
    }

    public static interface FolderInfo
    extends StdCallLibrary {
        public static final int MAX_PATH = 260;
        public static final int SHGFP_TYPE_CURRENT = 0;
        public static final int SHGFP_TYPE_DEFAULT = 1;
        public static final int CSIDL_APPDATA = 26;
        public static final int CSIDL_WINDOWS = 36;

        public int SHGetFolderPathW(Pointer var1, int var2, Pointer var3, int var4, char[] var5);
    }

    public static interface Dummy
    extends Library {
        public void dummy();
    }
}

