/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileOrArray
implements DataInput {
    RandomAccessFile rf;
    String filename;
    byte[] arrayIn;
    int arrayInPtr;

    public RandomAccessFileOrArray(String string) throws IOException {
        this.filename = string;
        this.rf = new RandomAccessFile(string, "r");
    }

    public RandomAccessFileOrArray(byte[] byArray) {
        this.arrayIn = byArray;
    }

    public RandomAccessFileOrArray(RandomAccessFileOrArray randomAccessFileOrArray) {
        this.filename = randomAccessFileOrArray.filename;
        this.arrayIn = randomAccessFileOrArray.arrayIn;
    }

    public int read() throws IOException {
        if (this.arrayIn == null) {
            return this.rf.read();
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        return this.arrayIn[this.arrayInPtr++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.arrayIn == null) {
            return this.rf.read(byArray, n, n2);
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        if (this.arrayInPtr + n2 > this.arrayIn.length) {
            n2 = this.arrayIn.length - this.arrayInPtr;
        }
        System.arraycopy(this.arrayIn, this.arrayInPtr, byArray, n, n2);
        this.arrayInPtr += n2;
        return n2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        if (n <= 0) {
            return 0;
        }
        int n3 = this.getFilePointer();
        int n4 = n3 + n;
        if (n4 > (n2 = this.length())) {
            n4 = n2;
        }
        this.seek(n4);
        return n4 - n3;
    }

    void reOpen() throws IOException {
        if (this.filename != null) {
            this.close();
            this.rf = new RandomAccessFile(this.filename, "r");
        } else {
            this.arrayInPtr = 0;
        }
    }

    protected void insureOpen() throws IOException {
        if (this.filename != null && this.rf == null) {
            this.reOpen();
        }
    }

    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
    }

    public int length() throws IOException {
        if (this.arrayIn == null) {
            return (int)this.rf.length();
        }
        return this.arrayIn.length;
    }

    public void seek(int n) throws IOException {
        if (this.arrayIn == null) {
            this.insureOpen();
            this.rf.seek(n);
        } else {
            this.arrayInPtr = n;
        }
    }

    public int getFilePointer() throws IOException {
        if (this.arrayIn == null) {
            return (int)this.rf.getFilePointer();
        }
        return this.arrayInPtr;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    int n2 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(n2);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

