/*
 * Decompiled with CFR 0.152.
 */
package cloverantlr;

import cloverantlr.CharQueue;
import cloverantlr.CharStreamException;

public abstract class InputBuffer {
    protected int nMarkers = 0;
    protected int markerOffset = 0;
    protected int numToConsume = 0;
    protected CharQueue queue = new CharQueue(1);

    public void commit() {
        --this.nMarkers;
    }

    public void consume() {
        ++this.numToConsume;
    }

    public abstract void fill(int var1) throws CharStreamException;

    public String getLAChars() {
        StringBuffer la = new StringBuffer();
        for (int i = this.markerOffset; i < this.queue.nbrEntries; ++i) {
            la.append(this.queue.elementAt(i));
        }
        return la.toString();
    }

    public String getMarkedChars() {
        StringBuffer marked = new StringBuffer();
        for (int i = 0; i < this.markerOffset; ++i) {
            marked.append(this.queue.elementAt(i));
        }
        return marked.toString();
    }

    public boolean isMarked() {
        return this.nMarkers != 0;
    }

    public char LA(int i) throws CharStreamException {
        this.fill(i);
        return this.queue.elementAt(this.markerOffset + i - 1);
    }

    public int mark() {
        this.syncConsume();
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int mark) {
        this.syncConsume();
        this.markerOffset = mark;
        --this.nMarkers;
    }

    protected void syncConsume() {
        while (this.numToConsume > 0) {
            if (this.nMarkers > 0) {
                ++this.markerOffset;
            } else {
                this.queue.removeFirst();
            }
            --this.numToConsume;
        }
    }
}

