/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import com.cenqua.clover.context.RegexpContext;
import com.cenqua.clover.instr.FileStructureInfo;
import java.io.Serializable;
import java.util.regex.Pattern;

public class MethodRegexpContext
extends RegexpContext
implements Serializable {
    private static final long serialVersionUID = -6347073452052848499L;
    private int maxComplexity;

    public MethodRegexpContext(MethodRegexpContext ctx) {
        this(ctx.getIndex(), ctx.getName(), ctx.getPattern(), ctx.getMaxComplexity());
    }

    public MethodRegexpContext(String name, Pattern pattern) {
        this(-1, name, pattern, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(String name, Pattern pattern, int maxComplexity) {
        this(-1, name, pattern, maxComplexity);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern) {
        this(index, name, pattern, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern, int maxComplexity) {
        super(index, name, pattern);
        this.maxComplexity = maxComplexity;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public boolean matches(FileStructureInfo.MethodMarker methodMarker) {
        return super.matches(methodMarker.getNormalisedSignature()) && methodMarker.getMethod().getMetrics().getComplexity() <= this.maxComplexity;
    }

    public boolean isEquivalent(RegexpContext other) {
        return other instanceof MethodRegexpContext && ((MethodRegexpContext)other).getMaxComplexity() == this.maxComplexity && super.isEquivalent(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodRegexpContext that = (MethodRegexpContext)o;
        return this.maxComplexity == that.maxComplexity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxComplexity;
        return result;
    }
}

