/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.Annotation;
import com.cenqua.clover.instr.AnnotationValue;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.StringifiedAnnotationValue;
import com.cenqua.clover.instr.TestDetector;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultTestDetector
implements TestDetector {
    public static final String TEST_ANNO_NAME = "Test";
    public static final String TESTNG_TEST_ANNO_NAME = "org.testng.annotations.Test";
    public static final String TESTNG_EXPECTED_ANNO_NAME = "org.testng.annotations.ExpectedExceptions";
    public static final String EXPECTED_ANNO_NAME = "ExpectedExceptions";
    public static final String ORG_JUNIT_NAME = "org.junit";
    public static final String JUNIT_TEST_ANNO_NAME = "org.junit.Test";
    public static final String JUNIT_IGNORE_ANNO_NAME = "org.junit.Ignore";
    public static final String IGNORE_ANNO_NAME = "Ignore";
    public static final String EXPECTED_EXCEPTIONS_ATTR_NAME = "expectedExceptions";
    public static final String EXPECTED_EXCEPTION_ATTR_NAME = "expectedException";
    public static final String EXPECTED_ATTR_NAME = "expected";
    public static final String VALUE_ATTR_NAME = "value";
    public static final String SPECIFICATION_NAME = "Specification";
    public static final String INSTINCT_SPECIFICATION_NAME = "com.googlecode.instinct.marker.annotate.Specification";
    private static final Pattern XDOCLET_NVP_PATTERN = Pattern.compile("\\s*(\\S+)\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern WS_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static final Pattern DOT_SPLIT_PATTERN = Pattern.compile("\\.");

    public boolean isClassMatch(InstrumentationState state, Map tags, Modifiers mods, String pkgName, String classname, String superclass) {
        if (state.getCfg().isJava15() && mods != null && (mods.containsAnnotation(TESTNG_TEST_ANNO_NAME) || mods.containsAnnotation(TEST_ANNO_NAME)) || tags != null && tags.containsKey("testng.test")) {
            return true;
        }
        return !(!this.strContains(classname, "test") && !this.strEquals(superclass, "TestCase") || !state.getCfg().isJava15() && !this.strContains(superclass, "test"));
    }

    private boolean strContains(String target, String str) {
        return target != null && target.toLowerCase().indexOf(str) >= 0;
    }

    private boolean strEquals(String target, String str) {
        return target != null && target.equals(str);
    }

    public boolean isMethodMatch(InstrumentationState state, MethodSignature sig) {
        if (sig != null && !Modifier.isAbstract(sig.getModifiers()) && Modifier.isPublic(sig.getModifiers()) && sig.getReturnType() != null) {
            if (state.getCfg().isJava15() && (sig.getFullModifiers().containsAnnotation(JUNIT_TEST_ANNO_NAME) || sig.getFullModifiers().containsAnnotation(TESTNG_TEST_ANNO_NAME) || sig.getFullModifiers().containsAnnotation(TEST_ANNO_NAME)) && !sig.getFullModifiers().containsAnnotation(JUNIT_IGNORE_ANNO_NAME) && !sig.getFullModifiers().containsAnnotation(IGNORE_ANNO_NAME) || sig.getTags().containsKey("test") || sig.getTags().containsKey("testng.test")) {
                return true;
            }
            if (sig.getName().startsWith("test") && !sig.hasParams()) {
                return true;
            }
        }
        return false;
    }

    public static String[] getExpectedExceptionsFor(InstrumentationState state, MethodSignature sig) {
        HashSet exceptionNames = new HashSet();
        DefaultTestDetector.expectedExceptionsFromAnnotations(state, sig, exceptionNames);
        if (exceptionNames.size() == 0) {
            DefaultTestDetector.expectedExceptionsFromJavadoc(state, sig, exceptionNames);
        }
        return exceptionNames.toArray(new String[exceptionNames.size()]);
    }

    private static void expectedExceptionsFromJavadoc(InstrumentationState state, MethodSignature sig, Set exceptionNames) {
        Map tags = sig.getTags();
        if (tags != null && tags.size() > 0) {
            DefaultTestDetector.extractExpectedExceptions("testng.test", EXPECTED_EXCEPTIONS_ATTR_NAME, exceptionNames, tags);
            DefaultTestDetector.extractExpectedExceptions("testng.expected-exceptions", VALUE_ATTR_NAME, exceptionNames, tags);
        }
    }

    private static void extractExpectedExceptions(String tagName, String attributeName, Set exceptionNames, Map tags) {
        List testTagValues = (List)tags.get(tagName);
        if (testTagValues != null) {
            for (int i = 0; i < testTagValues.size(); ++i) {
                DefaultTestDetector.processTagValue(attributeName, exceptionNames, (String)testTagValues.get(i));
            }
        }
    }

    private static void processTagValue(String attributeName, Set exceptionNames, String testTagValue) {
        Matcher testTagValueMatcher = XDOCLET_NVP_PATTERN.matcher(testTagValue);
        if (testTagValueMatcher.find()) {
            String attrName = testTagValueMatcher.group(1);
            String attrValue = testTagValueMatcher.group(2);
            if (attributeName.equals(attrName)) {
                DefaultTestDetector.processExceptionNames(exceptionNames, attrValue);
            }
        }
    }

    private static void processExceptionNames(Set exceptionNames, String attrValue) {
        String[] classNames = WS_SPLIT_PATTERN.split(attrValue);
        for (int j = 0; j < classNames.length; ++j) {
            if (!DefaultTestDetector.looksLikeFQClassName(classNames[j])) continue;
            exceptionNames.add(classNames[j]);
        }
    }

    private static boolean looksLikeFQClassName(String className) {
        if (className == null) {
            return false;
        }
        String[] parts = DOT_SPLIT_PATTERN.split(className);
        for (int i = 0; i < parts.length; ++i) {
            if (DefaultTestDetector.isIdent(parts[i])) continue;
            return false;
        }
        return true;
    }

    private static void expectedExceptionsFromAnnotations(InstrumentationState state, MethodSignature sig, Set exceptionNames) {
        if (state.getCfg().isJava15()) {
            Annotation specificationAnnotation;
            Annotation expectedExceptionsAnnotation;
            AnnotationValue expectedAttrValue = null;
            Annotation testAnnotation = DefaultTestDetector.findTestAnnotation(sig);
            if (testAnnotation != null) {
                expectedAttrValue = DefaultTestDetector.extractExpectedAttrValue(sig, testAnnotation);
            }
            if (expectedAttrValue == null && (expectedExceptionsAnnotation = DefaultTestDetector.findExpectedExceptionsAnnotation(sig)) != null) {
                expectedAttrValue = DefaultTestDetector.extractValueAttrValue(sig, expectedExceptionsAnnotation);
            }
            if (expectedAttrValue == null && (specificationAnnotation = DefaultTestDetector.findSpecificationAnnotation(sig)) != null) {
                expectedAttrValue = DefaultTestDetector.extractExpectedAttrValue(sig, specificationAnnotation);
            }
            if (expectedAttrValue != null) {
                DefaultTestDetector.extractExpectedExceptions(exceptionNames, expectedAttrValue);
            }
        }
    }

    private static Annotation findTestAnnotation(MethodSignature sig) {
        Annotation testAnnotation = sig.getFullModifiers().getAnnotation(JUNIT_TEST_ANNO_NAME);
        testAnnotation = testAnnotation != null ? testAnnotation : sig.getFullModifiers().getAnnotation(TESTNG_TEST_ANNO_NAME);
        testAnnotation = testAnnotation != null ? testAnnotation : sig.getFullModifiers().getAnnotation(TEST_ANNO_NAME);
        return testAnnotation;
    }

    private static Annotation findExpectedExceptionsAnnotation(MethodSignature sig) {
        Annotation expectedAnnotation = sig.getFullModifiers().getAnnotation(EXPECTED_ANNO_NAME);
        return expectedAnnotation != null ? expectedAnnotation : sig.getFullModifiers().getAnnotation(TESTNG_EXPECTED_ANNO_NAME);
    }

    private static Annotation findSpecificationAnnotation(MethodSignature sig) {
        Annotation specificationAnnotation = sig.getFullModifiers().getAnnotation(INSTINCT_SPECIFICATION_NAME);
        return specificationAnnotation != null ? specificationAnnotation : sig.getFullModifiers().getAnnotation(SPECIFICATION_NAME);
    }

    private static AnnotationValue extractExpectedAttrValue(MethodSignature sig, Annotation testAnnotation) {
        AnnotationValue value = testAnnotation.getAttribute(EXPECTED_EXCEPTIONS_ATTR_NAME);
        value = value != null ? value : testAnnotation.getAttribute(EXPECTED_ATTR_NAME);
        return value != null ? value : testAnnotation.getAttribute(EXPECTED_EXCEPTION_ATTR_NAME);
    }

    private static AnnotationValue extractValueAttrValue(MethodSignature sig, Annotation expectedExceptionsAnnotation) {
        return expectedExceptionsAnnotation.getAttribute(VALUE_ATTR_NAME);
    }

    private static void extractExpectedExceptions(Set exceptionNames, AnnotationValue expectedAttrValue) {
        List exceptionsNameValues = expectedAttrValue.toList();
        for (int i = 0; i < exceptionsNameValues.size(); ++i) {
            StringifiedAnnotationValue classNameValue;
            String className;
            AnnotationValue exceptionName = (AnnotationValue)exceptionsNameValues.get(i);
            if (!(exceptionName instanceof StringifiedAnnotationValue) || (className = DefaultTestDetector.stripClassNameFromDotClassExpression(classNameValue = (StringifiedAnnotationValue)exceptionName)) == null) continue;
            exceptionNames.add(className);
        }
    }

    private static String stripClassNameFromDotClassExpression(StringifiedAnnotationValue classNameValue) {
        String typeName = null;
        if (classNameValue.getValue().endsWith(".class")) {
            typeName = classNameValue.getValue().substring(0, classNameValue.getValue().lastIndexOf(".class"));
            String[] parts = DOT_SPLIT_PATTERN.split(typeName);
            for (int i = 0; i < parts.length; ++i) {
                if (DefaultTestDetector.isIdent(parts[i])) continue;
                return null;
            }
        }
        return typeName;
    }

    private static boolean isIdent(String ident) {
        if (ident == null || ident.length() == 0 || !Character.isJavaIdentifierStart(ident.charAt(0))) {
            return false;
        }
        for (int i = 1; i < ident.length(); ++i) {
            if (Character.isJavaIdentifierPart(ident.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

