/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.TestDetector;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class TestSpec
implements TestDetector {
    private Pattern pkgPattern;
    private Pattern classAnnotationPattern;
    private Pattern classPattern;
    private Pattern superPattern;
    private Pattern classTagPattern;
    private Pattern methodAnnotationPattern;
    private Pattern methodPattern;
    private Pattern methodReturnTypePattern;
    private Pattern methodTagPattern;

    public TestSpec() {
    }

    public TestSpec(TestSpec spec) {
        this.pkgPattern = spec.pkgPattern;
        this.classAnnotationPattern = spec.classAnnotationPattern;
        this.classPattern = spec.classPattern;
        this.superPattern = spec.superPattern;
        this.classTagPattern = spec.classTagPattern;
        this.methodAnnotationPattern = spec.methodAnnotationPattern;
        this.methodPattern = spec.methodPattern;
        this.methodReturnTypePattern = spec.methodReturnTypePattern;
        this.methodTagPattern = spec.methodTagPattern;
    }

    public void setPkgPattern(Pattern pkgPattern) {
        this.pkgPattern = pkgPattern;
    }

    public boolean pkgMatches(String pkg) {
        return this.pkgPattern == null || this.pkgPattern.matcher(pkg).matches();
    }

    public void setClassAnnotationPattern(Pattern classAnnotationPattern) {
        this.classAnnotationPattern = classAnnotationPattern;
    }

    public boolean classAnnotationMatches(Modifiers m) {
        return this.classAnnotationPattern == null || m != null && m.containsAnnotation(this.classAnnotationPattern);
    }

    public void setClassTagPattern(Pattern classTagPattern) {
        this.classTagPattern = classTagPattern;
    }

    public boolean classTagMatches(Map tags) {
        return this.classTagPattern == null || tags != null && this.tagsMatch(this.classTagPattern, tags);
    }

    private boolean tagsMatch(Pattern javaDocPattern, Map tags) {
        Iterator it = tags.keySet().iterator();
        while (it.hasNext()) {
            if (!javaDocPattern.matcher((String)it.next()).matches()) continue;
            return true;
        }
        return false;
    }

    public Pattern getMethodTagPattern() {
        return this.methodTagPattern;
    }

    public void setMethodTagPattern(Pattern methodTagPattern) {
        this.methodTagPattern = methodTagPattern;
    }

    public boolean methodTagMatches(Map tags) {
        return this.methodTagPattern == null || tags != null && this.tagsMatch(this.methodTagPattern, tags);
    }

    public void setClassPattern(Pattern classPattern) {
        this.classPattern = classPattern;
    }

    public boolean classMatches(String className) {
        return this.classPattern == null || this.classPattern.matcher(className).matches();
    }

    public void setSuperPattern(Pattern superPattern) {
        this.superPattern = superPattern;
    }

    public boolean superMatches(String superName) {
        return this.superPattern == null || this.superPattern.matcher(superName).matches();
    }

    public void setMethodAnnotationPattern(Pattern methodAnnotationPattern) {
        this.methodAnnotationPattern = methodAnnotationPattern;
    }

    public boolean methodAnnotationMatches(Modifiers modifiers) {
        return this.methodAnnotationPattern == null || modifiers.containsAnnotation(this.methodAnnotationPattern);
    }

    public void setMethodPattern(Pattern methodPattern) {
        this.methodPattern = methodPattern;
    }

    public boolean methodMatches(String method) {
        return this.methodPattern == null || this.methodPattern.matcher(method).matches();
    }

    public void setMethodReturnTypePattern(Pattern methodReturnsPattern) {
        this.methodReturnTypePattern = methodReturnsPattern;
    }

    public boolean methodReturnPatternMatches(String methodReturnType) {
        return methodReturnType != null && (this.methodReturnTypePattern == null || this.methodReturnTypePattern.matcher(methodReturnType).matches());
    }

    public boolean isClassMatch(InstrumentationState state, Map tags, Modifiers mods, String pkgName, String className, String superName) {
        return this.pkgMatches(pkgName) && this.classMatches(className) && this.superMatches(superName) && this.classAnnotationMatches(mods) && this.classTagMatches(tags);
    }

    public boolean isMethodMatch(InstrumentationState state, MethodSignature sig) {
        return this.methodMatches(sig.getName()) && this.methodAnnotationMatches(sig.getFullModifiers()) && this.methodReturnPatternMatches(sig.getReturnType()) && this.methodTagMatches(sig.getTags());
    }
}

