/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BaseFileInfo;
import java.io.Serializable;
import java.util.Comparator;

public class SourceRegion
implements Serializable {
    private static final long serialVersionUID = 2159421864958315258L;
    protected BaseFileInfo containingFile;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    public static final Comparator SOURCE_ORDER_COMP = new RegionStartComparator();

    public SourceRegion(int startLine, int startColumn) {
        this(null, startLine, startColumn, startLine, startColumn);
    }

    public SourceRegion(int startLine, int startColumn, int endLine, int endColumn) {
        this(null, startLine, startColumn, endLine, endColumn);
    }

    public SourceRegion(BaseFileInfo containingFile, SourceRegion other) {
        this(containingFile, other.startLine, other.startColumn, other.endLine, other.endColumn);
    }

    public SourceRegion(BaseFileInfo containingFile, int startLine, int startColumn, int endLine, int endColumn) {
        this.containingFile = containingFile;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public BaseFileInfo getContainingFile() {
        return this.containingFile;
    }

    public void setContainingFile(BaseFileInfo containingFile) {
        this.containingFile = containingFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceRegion that = (SourceRegion)o;
        if (this.endColumn != that.endColumn) {
            return false;
        }
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        if (this.startLine != that.startLine) {
            return false;
        }
        return !(this.containingFile == null ? that.containingFile != null : !this.containingFile.equals(that.containingFile));
    }

    public int hashCode() {
        int result = this.startLine;
        result = 29 * result + this.startColumn;
        result = 29 * result + this.endLine;
        result = 29 * result + this.endColumn;
        return result;
    }

    public static class RegionStartComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            SourceRegion reg1 = (SourceRegion)obj1;
            SourceRegion reg2 = (SourceRegion)obj2;
            int sld = reg1.getStartLine() - reg2.getStartLine();
            if (sld == 0) {
                int scd = reg1.getStartColumn() - reg2.getStartColumn();
                if (scd == 0) {
                    int eld = reg1.getEndLine() - reg2.getEndLine();
                    if (eld == 0) {
                        return reg1.getEndColumn() - reg2.getEndColumn();
                    }
                    return eld;
                }
                return scd;
            }
            return sld;
        }
    }
}

