/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.StackTraceInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestCaseInfo
implements Serializable {
    static final long serialVersionUID = 8226248624214796483L;
    public static final int DEFAULT_SLICE_ID_OFFSET = 0;
    private transient MethodInfo sourceMethod;
    private transient ClassInfo runtimeType;
    private transient Integer id;
    private String runtimeTypeName;
    private String sourceMethodName;
    private boolean hasResult = false;
    private long startTime;
    private long endTime;
    private float time = -1.0f;
    private boolean error;
    private boolean failure;
    private String failMessage;
    private String failType;
    private String failFullMessage;
    private String testName;
    private Integer hashCode = null;
    private transient StackTraceInfo stackTrace;

    private TestCaseInfo(long startTime, long endTime, String runtimeTypeName, String sourceMethodName) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.runtimeTypeName = runtimeTypeName;
        this.sourceMethodName = sourceMethodName;
    }

    public TestCaseInfo(Integer id, ClassInfo runtimeType, MethodInfo sourceMethod) {
        this(id, runtimeType, sourceMethod.getSimpleName());
        this.sourceMethod = sourceMethod;
    }

    public TestCaseInfo(Integer id, ClassInfo runtimeType, String testName) {
        this.id = id;
        this.runtimeType = runtimeType;
        this.testName = testName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isResolved() {
        return this.runtimeType != null && this.sourceMethod != null;
    }

    public boolean resolve(ProjectInfo project) {
        String rtClassname = this.runtimeTypeName.replaceAll("\\.[0-9]+", "");
        this.runtimeType = (ClassInfo)project.findClass(rtClassname);
        int lastDot = this.sourceMethodName.lastIndexOf(".");
        if (lastDot > 0 && lastDot < this.sourceMethodName.length()) {
            String srcClassname = this.sourceMethodName.substring(0, lastDot);
            this.testName = this.sourceMethodName.substring(lastDot + 1);
            ClassInfo srcClass = rtClassname.equals(srcClassname) ? this.runtimeType : (ClassInfo)project.findClass(srcClassname);
            if (srcClass != null) {
                this.sourceMethod = srcClass.getTestMethodDeclaration(this.testName);
            }
            if (this.runtimeType != null) {
                this.runtimeType.addTestCase(this);
            }
            if (this.stackTrace != null) {
                this.stackTrace.resolve(project);
            }
        }
        return this.isResolved();
    }

    public Object readResolve() throws ObjectStreamException {
        TestCaseInfo info = Factory.getInstance(this);
        StackTraceInfo strace = info.getStackTrace();
        if (strace != null) {
            strace.setOriginatingTest(info);
        }
        return info;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.failFullMessage != null) {
            this.stackTrace = new StackTraceInfo(this, this.failFullMessage);
        }
    }

    public String getKey() {
        return TestCaseInfo.makeKey(this.runtimeTypeName, this.sourceMethodName, this.startTime);
    }

    public static String makeKey(String runtimeTypeName, String sourceMethodName, long startTime) {
        return runtimeTypeName + "/" + sourceMethodName + "/" + startTime;
    }

    public String getClassName() {
        return this.runtimeType.getName();
    }

    public String getTestName() {
        return this.testName;
    }

    public float getTime() {
        return this.startTime == 0L ? this.time : (float)(this.endTime - this.startTime) / 1000.0f;
    }

    public boolean isError() {
        return this.hasResult && this.error;
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isFailure() {
        return this.hasResult && this.failure;
    }

    public void setFailure(boolean failure) {
        this.failure = failure;
    }

    public boolean isSuccess() {
        return this.hasResult && !this.isFailure() && !this.isError();
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    public String getFailType() {
        return this.failType;
    }

    public void setFailType(String failType) {
        this.failType = failType;
    }

    public String getFailFullMessage() {
        return this.failFullMessage;
    }

    public void setFailFullMessage(String failFullMessage) {
        this.failFullMessage = failFullMessage;
        if (failFullMessage != null) {
            this.stackTrace = new StackTraceInfo(this, failFullMessage);
        }
    }

    public StackTraceInfo getStackTrace() {
        return this.stackTrace;
    }

    public ClassInfo getRuntimeType() {
        return this.runtimeType;
    }

    public ClassInfo getContainingClass() {
        return this.runtimeType;
    }

    public MethodInfo getSourceMethod() {
        return this.sourceMethod;
    }

    public String getQualifiedName() {
        return this.runtimeType.getQualifiedName() + "." + this.getTestName();
    }

    public String getRuntimeTypeName() {
        return this.runtimeTypeName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseInfo that = (TestCaseInfo)o;
        if (this.endTime != that.endTime) {
            return false;
        }
        if (this.error != that.error) {
            return false;
        }
        if (this.failure != that.failure) {
            return false;
        }
        if (this.hasResult != that.hasResult) {
            return false;
        }
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.failFullMessage != null ? !this.failFullMessage.equals(that.failFullMessage) : that.failFullMessage != null) {
            return false;
        }
        if (this.failMessage != null ? !this.failMessage.equals(that.failMessage) : that.failMessage != null) {
            return false;
        }
        if (this.failType != null ? !this.failType.equals(that.failType) : that.failType != null) {
            return false;
        }
        if (this.runtimeTypeName != null ? !this.runtimeTypeName.equals(that.runtimeTypeName) : that.runtimeTypeName != null) {
            return false;
        }
        if (this.sourceMethodName != null ? !this.sourceMethodName.equals(that.sourceMethodName) : that.sourceMethodName != null) {
            return false;
        }
        return !(this.testName != null ? !this.testName.equals(that.testName) : that.testName != null);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.runtimeTypeName != null ? this.runtimeTypeName.hashCode() : 0;
            result = 31 * result + (this.sourceMethodName != null ? this.sourceMethodName.hashCode() : 0);
            result = 31 * result + (this.hasResult ? 1 : 0);
            result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
            result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
            result = 31 * result + (this.error ? 1 : 0);
            result = 31 * result + (this.failure ? 1 : 0);
            result = 31 * result + (this.failMessage != null ? this.failMessage.hashCode() : 0);
            result = 31 * result + (this.failType != null ? this.failType.hashCode() : 0);
            result = 31 * result + (this.failFullMessage != null ? this.failFullMessage.hashCode() : 0);
            result = 31 * result + (this.testName != null ? this.testName.hashCode() : 0);
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public String toString() {
        return "TestCaseInfo[id=" + this.id + ", runtimeTypeName='" + this.runtimeType + '\'' + ", testName='" + this.testName + '\'' + ", sourceMethodName='" + this.sourceMethodName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", pass=" + !this.failure + ']';
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private static Map<String, TestCaseInfo> instanceCache = new HashMap<String, TestCaseInfo>();
        private static int sliceOffset = 0;

        public static void setInstanceCache(Map<String, TestCaseInfo> instanceCache) {
            if (!Factory.instanceCache.isEmpty()) {
                throw new IllegalStateException("TestCaseInfo instance cache already in use");
            }
            Factory.instanceCache = instanceCache;
        }

        public static void reset() {
            instanceCache.clear();
            sliceOffset = 0;
        }

        public static TestCaseInfo getInstance(TestCaseInfo tci) {
            TestCaseInfo result = instanceCache.get(tci.getKey());
            if (result == null) {
                result = tci;
                tci.setId(new Integer(sliceOffset++));
                instanceCache.put(tci.getKey(), tci);
            }
            return result;
        }

        public static TestCaseInfo getInstanceForSlice(PerTestRecordingTranscript recording) {
            TestCaseInfo tci = new TestCaseInfo(recording.getStart(), recording.getEnd(), recording.getTestTypeName(), recording.getTestMethodName());
            TestCaseInfo result = instanceCache.get(tci.getKey());
            if (result == null) {
                result = tci;
                tci.setHasResult(true);
                String stackTrace = recording.getStackTrace();
                String exitMessage = recording.getExitMessage();
                tci.setError(!recording.isResultPassed() && stackTrace == null);
                tci.setFailure(!recording.isResultPassed() && stackTrace != null);
                tci.setFailMessage(exitMessage);
                tci.setFailFullMessage(stackTrace);
                tci.setId(new Integer(sliceOffset++));
                instanceCache.put(tci.getKey(), tci);
            }
            return result;
        }

        public static Set<TestCaseInfo> getCacheValues() {
            return new HashSet<TestCaseInfo>(instanceCache.values());
        }
    }
}

