/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.org.jfree.chart.ChartRenderingInfo;
import clover.org.jfree.chart.ChartUtilities;
import clover.org.jfree.chart.JFreeChart;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageFragment;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.reporters.html.RenderDashboardAction;
import com.cenqua.clover.reporters.html.RenderFileAction;
import com.cenqua.clover.reporters.html.RenderPackageCoverageCloudAction;
import com.cenqua.clover.reporters.html.RenderPackageSummaryAction;
import com.cenqua.clover.reporters.html.RenderProjectCoverageCloudsAction;
import com.cenqua.clover.reporters.html.RenderTestResultAction;
import com.cenqua.clover.reporters.json.JSONHistoricalReporter;
import com.cenqua.clover.reporters.json.RenderMetricsJSONAction;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import com.cenqua.clover.reporters.util.HistoricalReportDescriptor;
import com.cenqua.clover.util.CloverExecutor;
import com.cenqua.clover.util.CloverExecutors;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.format.HtmlFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class FullHtmlReporter
extends HtmlReporter {
    public static final String[] HTML_SORT_OPTIONS_NAMES = new String[]{"coverage ascending", "coverage descending", "alphabetic"};
    public static final String[] HTML_SORT_OPTIONS_VALUES = new String[]{"asc", "desc", "alpha"};
    public static final Map HTML_HOMEPAGE_VALUES = new HashMap();
    private static final String HTML_HOMEPAGE_DEFAULT = "dashboard";
    private static final Map SUMMARY_TABS;
    private static final String TAB_CLASSES = "Classes";
    private static final String TAB_TESTS = "Tests";
    private static final String TAB_RESULTS = "Results";
    private Comparator mListComparator;
    private Comparator mDetailComparator;
    private String mPageTitle;
    private String mPageTitleAnchor;
    private String mPageTitleTarget;
    final Comparator TEST_SORT_ORDER = HasMetricsSupport.newTestListComparator();
    final Comparator TEST_CASE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object1) {
            TestCaseInfo t = (TestCaseInfo)object;
            TestCaseInfo t1 = (TestCaseInfo)object1;
            if (t1.isSuccess() & t.isSuccess()) {
                return 0;
            }
            if (!t1.isSuccess()) {
                return 1;
            }
            return -1;
        }
    };
    private Current current;

    public FullHtmlReporter(CloverReportConfig cfg) throws IOException, CloverException {
        super(cfg);
        this.mPageTitle = this.mCfg.getTitle();
        this.mPageTitleAnchor = this.mCfg.getTitleAnchor() != null ? this.mCfg.getTitleAnchor() : "";
        this.mPageTitleTarget = this.mCfg.getTitleTarget() != null ? this.mCfg.getTitleTarget() : "_top";
        String comp = this.mCfg.getFormat().getOrderby();
        this.mListComparator = HasMetricsSupport.LEX_COMP;
        this.mDetailComparator = HasMetricsSupport.PC_ASCENDING_COMP;
        if (comp != null) {
            this.mDetailComparator = HasMetricsSupport.getHasMetricsComparator(comp);
        }
    }

    private void insertCommonProps(VelocityContext context, String pkg) {
        context.put("rootRelPath", this.mHelper.getRootRelPath(pkg));
        context.put("pageTitle", this.mPageTitle);
        String title = this.mPageTitle != null ? this.mPageTitle : "Clover";
        context.put("headerTitle", pkg.length() == 0 ? title : title + ": " + pkg);
        context.put("pageTitleIsLink", this.mPageTitleAnchor != null && this.mPageTitleAnchor.length() > 0);
        context.put("pageTitleAnchor", this.mPageTitleAnchor);
        context.put("pageTitleTarget", this.mPageTitleTarget);
        context.put("renderUtil", this.mHelper);
        context.put("startTimestamp", this.DATE_FORMAT.format(this.coverageTS));
        String cloverURL = "http://www.atlassian.com/software/clover";
        context.put("cloverURL", cloverURL);
        context.put("cloverReleaseNum", "2.5.1");
        context.put("reportTimestamp", this.mReportTS);
        context.put("showEmpty", this.mCfg.getFormat().getShowEmpty());
        context.put("showSrc", this.mCfg.getFormat().getSrcLevel());
        context.put("showBars", this.mCfg.getFormat().getShowBars());
        context.put("noCache", this.mCfg.getFormat().getNoCache());
        context.put("expired", CloverLicenseInfo.EXPIRED);
        context.put("outOfDateMessage", "The source file used to generate this report was changed after Clover generated coverage information. The coverage reported may not match the source lines. You should regenerate the coverage information and the report to ensure the files are in sync.");
        context.put("charset", this.mCfg.getCharset());
        FullHtmlReporter.insertLicenseMessages(context);
    }

    static void insertLicenseMessages(VelocityContext context) {
        String headerMsg = CloverLicenseInfo.OWNER_STMT + " ";
        String footerMsg = CloverLicenseInfo.OWNER_STMT + " ";
        if (CloverLicenseInfo.VERBOSE) {
            if (CloverLicenseInfo.EXPIRED) {
                headerMsg = headerMsg + CloverLicenseInfo.POST_EXPIRY_STMT + " " + CloverLicenseInfo.CONTACT_INFO_STMT;
                footerMsg = footerMsg + CloverLicenseInfo.POST_EXPIRY_STMT;
            } else {
                headerMsg = headerMsg + CloverLicenseInfo.PRE_EXPIRY_STMT;
                footerMsg = footerMsg + CloverLicenseInfo.PRE_EXPIRY_STMT;
            }
        }
        if (CloverLicenseInfo.EXPIRES && !CloverLicenseInfo.EXPIRED) {
            context.put("evalMsg", "This report was generated with an evaluation license. <a href=\"http://www.atlassian.com/software/clover\">Purchase Clover</a> or <a href=\"http://confluence.atlassian.com/x/JAgQCQ\">configure your license.</a>");
        }
        context.put("headerMsg", HtmlFormatter.format(headerMsg));
        context.put("footerMsg", HtmlFormatter.format(footerMsg));
    }

    public void createHistoricalReport() throws Exception {
        CloverStartup.permsCheck(16L);
        Logger.getInstance().info("Writing historical report to '" + this.mBasePath + "'");
        HistoricalReportDescriptor descriptor = new HistoricalReportDescriptor(this.mCfg);
        boolean hasHistoricalData = descriptor.gatherHistoricalModels();
        if (!hasHistoricalData) {
            Logger.getInstance().warn("No historical data found. No HTML historical report can be generated.");
            return;
        }
        this.coverageTS = new Date(descriptor.getFirstTimestamp());
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, "");
        HtmlReportUtil.mergeTemplateToDir(this.mBasePath, "style.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.mBasePath, "roundedcorners.css", context);
        File outfile = new File(this.mBasePath, this.mCfg.getMainFileName());
        context.put("historical", descriptor);
        CloverReportConfig firstCurrentConfig = this.mCfg.getFirstCurrentConfig();
        if (firstCurrentConfig != null) {
            String relToCurrentRoot = FileUtils.getRelativePath(outfile.getParentFile(), firstCurrentConfig.getMainOutFile().getParentFile(), "/");
            relToCurrentRoot = "".equals(relToCurrentRoot) ? "" : relToCurrentRoot + "/";
            context.put("relToCurrentRoot", relToCurrentRoot);
            Format format = firstCurrentConfig.getFormat();
            if (format != null) {
                context.put("showSrc", format.getSrcLevel());
            }
        }
        context.put("hasmetrics", descriptor.getSubjectMetrics());
        context.put("endTimestamp", this.DATE_FORMAT.format(new Date(descriptor.getLastTimestamp())));
        if (descriptor.showMovers()) {
            context.put("allAdded", descriptor.getAddedDescriptors());
            context.put("allMovers", descriptor.getMoversDescriptors());
        }
        context.put("colSpan", new Integer(6));
        File imgDir = this.copyCommonImages();
        Historical historical = (Historical)this.mCfg;
        List charts = historical.getCharts();
        SortedMap data = descriptor.getHistoricalModels();
        ArrayList<String> chartNames = new ArrayList<String>();
        HashMap<String, String> imageMaps = new HashMap<String, String>();
        for (int i = 0; i < charts.size(); ++i) {
            String chartName = "chart" + i + ".jpg";
            chartNames.add(chartName);
            Historical.Chart chart = (Historical.Chart)charts.get(i);
            JFreeChart jFreeChart = CloverChartFactory.createJFreeChart(chart, data);
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            ChartUtilities.saveChartAsJPEG(new File(imgDir, chartName), 1.0f, jFreeChart, chart.getWidth(), chart.getHeight(), renderingInfo);
            String imageMap = ChartUtilities.getImageMap(chartName, renderingInfo);
            imageMaps.put(chartName, imageMap);
        }
        context.put("imageMaps", imageMaps);
        context.put("chartNames", chartNames);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/historical.vm");
        if (historical.isJson()) {
            JSONHistoricalReporter jsonReporter = new JSONHistoricalReporter(this.mCfg.getOutFile());
            jsonReporter.generateHistoricalJSON(context, data);
        }
        Logger.getInstance().info("Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCurrentReportImpl() throws Exception {
        CloverStartup.permsCheck(4L);
        long currentStartTime = System.currentTimeMillis();
        this.current = (Current)this.mCfg;
        List pkgs = this.getFullModel().getPackages();
        this.getFullModel().buildCaches();
        TreeInfo appSrcTree = new TreeInfo("", "App");
        TreeInfo appCloudTree = new TreeInfo("", "AppCloud");
        TreeInfo testSrcTree = new TreeInfo("testsrc-", "Test");
        try {
            List targetClasses = this.getConfiguredModel().getClasses(HasMetricsFilter.NO_OP);
            List testClasses = this.getTestModel().getClasses(HasMetricsFilter.NO_OP);
            List targetFiles = this.getFullModel().getFiles(new Current.SourceFileFilter());
            Map srcFileCharts = CloverChartFactory.generateSrcFileCharts(targetFiles, this.mBaseImgPath);
            CloverExecutor service = CloverExecutors.newCloverExecutor(this.current.getNumThreads(), "Clover");
            RenderFileAction.initThreadLocals();
            RenderMetricsJSONAction.initThreadLocals();
            Iterator it = pkgs.iterator();
            while (it.hasNext()) {
                PackageInfo pkg = (PackageInfo)it.next();
                Logger.getInstance().verbose("Processing package " + pkg.getName());
                long start = System.currentTimeMillis();
                this.processPackage(pkg, appSrcTree, appCloudTree, testSrcTree, service, srcFileCharts);
                long total = System.currentTimeMillis() - start;
                if (!Logger.isDebug()) continue;
                Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
            }
            this.renderDashboard(service, CloverChartFactory.generateHistogramChart(targetClasses, this.mBaseImgPath), CloverChartFactory.generateScatterChart(targetClasses, this.mBaseImgPath));
            this.renderProjectCoverageCloudPage(appCloudTree, service);
            this.renderBasePages();
            this.renderTestResultsPkgsSummaryPage();
            this.renderTopLeftPanePage();
            this.renderAggregatePkgPage(this.getConfiguredModel(), appSrcTree, true);
            this.renderPackagesSummaryPage(this.getConfiguredModel(), appSrcTree, true);
            this.renderAggregatePkgPage(this.getTestModel(), testSrcTree, false);
            this.renderPackagesSummaryPage(this.getTestModel(), testSrcTree, false);
            this.renderPkgClassesPage("classes-summary.vm", null, targetClasses, TAB_CLASSES, false);
            this.renderPkgClassesPage("classes-summary.vm", null, testClasses, TAB_TESTS, false);
            this.renderPkgClassesPage("classes-summary.vm", null, testClasses, TAB_RESULTS, true);
            this.copyCommonImages();
            service.shutdown();
            Interval timeOut = this.current.getTimeOut();
            if (!service.awaitTermination(timeOut.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                throw new CloverException("Timeout of '" + timeOut + "' reached during report generation. " + "Please increase this value and try again.");
            }
        }
        finally {
            RenderFileAction.resetThreadLocals();
            RenderMetricsJSONAction.resetThreadLocals();
        }
        long currentTotalTime = System.currentTimeMillis() - currentStartTime;
        int pkgCount = pkgs.size();
        long msPerPkg = pkgCount == 0 ? currentTotalTime : currentTotalTime / (long)pkgCount;
        Logger.getInstance().info("Done. Processed " + pkgCount + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
    }

    private void renderProjectCoverageCloudPage(TreeInfo appCloudTree, CloverExecutor service) throws Exception {
        VelocityContext cloudsContext = new VelocityContext();
        this.insertCommonProps(cloudsContext, "");
        service.submit(new RenderProjectCoverageCloudsAction(cloudsContext, this.mBasePath, appCloudTree, this.getConfiguredModel()));
    }

    protected ProjectInfo getConfiguredModel() {
        return this.mDb.getAppOnlyModel();
    }

    protected ProjectInfo getFullModel() {
        return this.mDb.getFullModel();
    }

    protected ProjectInfo getTestModel() {
        return this.mDb.getTestOnlyModel();
    }

    private void renderDashboard(CloverExecutor queue, CloverChartFactory.ChartInfo histogram, CloverChartFactory.ChartInfo scatter) throws Exception {
        VelocityContext ctx = new VelocityContext();
        this.insertCommonProps(ctx, "");
        ProjectInfo configuredProject = this.getConfiguredModel();
        RenderDashboardAction action = new RenderDashboardAction(ctx, this.mBasePath, configuredProject, this.getFullModel(), histogram, scatter);
        queue.submit(action);
        File outfile = new File(this.current.getOutFile(), "project.js");
        RenderMetricsJSONAction jsonAction = new RenderMetricsJSONAction(ctx, configuredProject, this.current, outfile, this.mHelper);
        queue.submit(jsonAction);
    }

    private File copyCommonImages() throws IOException {
        File imgDir = new File(this.mBasePath, "img");
        imgDir.mkdir();
        this.copyStaticResource("html_res", "img/logo.gif");
        this.copyStaticResource("html_res", "img/expand.gif");
        this.copyStaticResource("html_res", "img/collapse.gif");
        this.copyStaticResource("html_res", "img/icn_up.gif");
        this.copyStaticResource("html_res", "img/icn_down.gif");
        this.copyStaticResource("html_res", "img/back.gif");
        this.copyStaticResource("html_res", "img/more.gif");
        this.copyStaticResource("html_res", "img/more_dark.gif");
        this.copyStaticResource("html_res", "img/less.gif");
        this.copyStaticResource("html_res", "img/less_dark.gif");
        this.copyStaticResource("html_res", "img/test.gif");
        this.copyStaticResource("html_res", "img/cnrL_tl.gif");
        this.copyStaticResource("html_res", "img/cnrL_tr.gif");
        this.copyStaticResource("html_res", "img/spacer.gif");
        this.copyStaticResource("html_res", "img/tick.gif");
        this.copyStaticResource("html_res", "img/cloud.png");
        this.copyStaticResource("html_res", "img/clover.ico");
        this.copyStaticResource("html_res", "img/failure_gutter.gif");
        this.copyStaticResource("html_res", "overlibmws.js");
        this.copyStaticResource("html_res", "overlibmws_shadow.js");
        this.copyStaticResource("html_res", "clover.js");
        this.copyStaticResource("html_res", "utils.js");
        this.copyStaticResource("html_res", "cloud.js");
        this.copyStaticResource("html_res", "help.js");
        return imgDir;
    }

    private void copyStaticResource(String aLoadPath, String aName) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        File outfile = new File(this.mBasePath, aName);
        InputStream res = loader.getResourceAsStream(aLoadPath + "/" + aName);
        if (res == null) {
            throw new IOException("Resource not found: " + aLoadPath + "/" + aName);
        }
        BufferedInputStream in = new BufferedInputStream(res);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outfile));
        int b = ((InputStream)in).read();
        while (b >= 0) {
            ((OutputStream)out).write(b);
            b = ((InputStream)in).read();
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void processPackage(PackageInfo pkg, TreeInfo appSrcTree, TreeInfo appCloudTree, TreeInfo testSrcTree, CloverExecutor queue, Map charts) throws Exception {
        List files = pkg.getFiles();
        ProjectInfo projectInfo = this.getFullModel();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileInfo file = (FileInfo)it.next();
            if (this.mCfg.getFormat().getSrcLevel()) {
                VelocityContext context = new VelocityContext();
                this.insertCommonProps(context, file.getContainingPackage().getName());
                RenderFileAction action = new RenderFileAction(file, this.mHelper, this.current, context, this.mDb, projectInfo, charts);
                queue.submit(action);
            }
            this.renderTestPages(queue, file);
        }
        PackageInfo pkgAppInfo = (PackageInfo)this.getConfiguredModel().getNamedPackage(pkg.getName());
        PackageInfo pkgTestInfo = (PackageInfo)this.getTestModel().getNamedPackage(pkg.getName());
        List classes = pkgAppInfo != null ? pkgAppInfo.getClasses() : new LinkedList();
        List testClasses = pkgTestInfo != null ? pkgTestInfo.getClasses() : new LinkedList();
        this.renderPkgClassesPage("classes-summary.vm", pkg, classes, TAB_CLASSES, false);
        this.renderPkgClassesPage("classes-summary.vm", pkg, testClasses, TAB_TESTS, false);
        this.renderPkgClassesPage("classes-summary.vm", pkg, testClasses, TAB_RESULTS, true);
        if (pkgAppInfo != null) {
            this.renderPkgSummaryPage(pkgAppInfo, appSrcTree, pkgTestInfo != null, queue, true);
            this.renderPkgCloudPages(pkgAppInfo, appCloudTree, pkgTestInfo != null, queue);
        }
        if (pkgTestInfo != null) {
            this.renderPkgSummaryPage(pkgTestInfo, testSrcTree, pkgAppInfo != null, queue, false);
        }
        this.renderTestResultsPkgSummaryPages(pkg, testClasses);
    }

    private void renderTestPages(CloverExecutor queue, BaseFileInfo file) throws Exception {
        List classes = file.getClasses();
        Iterator clz = classes.iterator();
        while (clz.hasNext()) {
            ClassInfo aClass = (ClassInfo)clz.next();
            if (!aClass.isTestClass()) continue;
            Iterator tests = aClass.getTestCases().iterator();
            while (tests.hasNext()) {
                TestCaseInfo test = (TestCaseInfo)tests.next();
                VelocityContext context = new VelocityContext();
                this.insertCommonProps(context, file.getContainingPackage().getName());
                RenderTestResultAction testResultRenderer = new RenderTestResultAction(test, this.mHelper, (Current)this.mCfg, this.getConfiguredModel(), context, this.getFullModel(), this.mDb);
                queue.submit(testResultRenderer);
            }
        }
    }

    private void gatherAggregatePackages(Map pkgs, PackageFragment frag) {
        pkgs.put(frag.getQualifiedName(), frag);
        PackageFragment[] kids = frag.getChildren();
        for (int i = 0; kids != null && i < kids.length; ++i) {
            PackageFragment kid = kids[i];
            this.gatherAggregatePackages(pkgs, kid);
        }
    }

    private void renderAggregatePkgPage(ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = tree.getPathPrefix() + "agg-pkgs.html";
        File outfile = new File(this.mBasePath, filename);
        VelocityContext context = new VelocityContext();
        context.put("linkToClouds", linkToClouds);
        context.put("currentPageURL", filename);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        this.insertCommonProps(context, "");
        HashMap aggregatePkgs = new HashMap();
        PackageFragment[] roots = model.getPackageRoots();
        for (int i = 0; i < roots.length; ++i) {
            PackageFragment root = roots[i];
            this.gatherAggregatePackages(aggregatePkgs, root);
        }
        ArrayList kids = new ArrayList(aggregatePkgs.values());
        Collections.sort(kids, this.mDetailComparator);
        context.put("packageFragments", kids);
        context.put("tree", tree);
        HtmlReportUtil.addColumnsToContext(context, this.mCfg.getColumns().getPkgColumns(), model, kids);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/agg-pkgs.vm");
    }

    private void renderBasePages() throws Exception {
        File outfile = new File(this.mBasePath, this.mCfg.getMainFileName());
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", this.mCfg.getMainFileName());
        this.insertCommonProps(context, "");
        context.put("homepage", this.getHomepageValue());
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/" + this.mCfg.getMainFileName());
        HtmlReportUtil.mergeTemplateToDir(this.mBasePath, "style.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.mBasePath, "roundedcorners.css", context);
        this.copyStaticResource("html_res", "sorttable.js");
    }

    private String getHomepageValue() {
        String homepageKey = this.mCfg.getHomepage() != null ? this.mCfg.getHomepage() : HTML_HOMEPAGE_DEFAULT;
        return HTML_HOMEPAGE_VALUES.containsKey(homepageKey) ? HTML_HOMEPAGE_VALUES.get(homepageKey) : homepageKey;
    }

    private void renderTopLeftPanePage() throws Exception {
        File outfile = new File(this.mBasePath, "all-pkgs.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", "all-pkgs.html");
        context.put("reportConfig", this.mCfg);
        context.put("fileUtils", new FileUtils());
        List packages = this.getConfiguredModel().getPackages();
        Collections.sort(packages, this.mListComparator);
        this.insertCommonProps(context, "");
        context.put("packages", packages);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/all-pkgs.vm");
    }

    private void renderPackagesSummaryPage(String name, String templateName, VelocityContext context, ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = tree.getPathPrefix() + name;
        File outfile = new File(this.mBasePath, filename);
        context.put("currentPageURL", filename);
        List packages = model.getPackages();
        Collections.sort(packages, this.mDetailComparator);
        this.insertCommonProps(context, "");
        context.put("linkToClouds", linkToClouds);
        context.put("projectInfo", model);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        context.put("packages", packages);
        context.put("tree", tree);
        context.put("siblingPresent", Boolean.TRUE);
        HtmlReportUtil.addColumnsToContext(context, this.mCfg.getColumns().getPkgColumns(), model, packages);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, templateName);
    }

    private void renderPackagesSummaryPage(ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        this.renderPackagesSummaryPage("pkg-summary.html", "html_res/pkgs-summary.vm", new VelocityContext(), model, tree, linkToClouds);
    }

    private void renderTestResultsPkgsSummaryPage() throws Exception {
        File outfile = new File(this.mBasePath, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        ProjectInfo projectInfo = this.getFullModel().copy(new HasMetricsFilter(){

            public boolean accept(HasMetrics hm) {
                return !(hm instanceof BaseClassInfo) || ((BaseClassInfo)hm).isTestClass();
            }
        });
        List packages = projectInfo.getPackages();
        Collections.sort(packages, this.TEST_SORT_ORDER);
        context.put("currentPageURL", outfile.getName());
        this.insertCommonProps(context, "");
        this.insertCommonTestProps(context, packages, "package", null, projectInfo, "test-pkg-summary.html", "Project", "Packages");
        context.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-pkg-summary.vm");
    }

    private void renderPkgClassesPage(String outfileName, String templateName, PackageInfo pkg, List classes, VelocityContext context, String currentTabName, boolean isTests) throws Exception {
        File outdir = pkg != null ? CloverUtils.createOutDir(pkg, this.mBasePath) : this.mBasePath;
        Collections.sort(classes, this.mListComparator);
        File outfile = new File(outdir, outfileName);
        context.put("currentPageURL", outfileName);
        String name = pkg != null ? pkg.getName() : "All Classes";
        this.insertCommonProps(context, name);
        context.put("packageInfo", pkg);
        context.put("classlist", classes);
        context.put("currentTabName", currentTabName);
        context.put("isTests", isTests);
        context.put("topLevel", pkg == null);
        context.put("title", TAB_CLASSES);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/" + templateName);
    }

    private void renderPkgClassesPage(String templateName, PackageInfo pkg, List classes, String currentTabName, boolean isTests) throws Exception {
        String outfileName = (String)SUMMARY_TABS.get(currentTabName);
        VelocityContext context = new VelocityContext();
        context.put("tabs", SUMMARY_TABS);
        this.renderPkgClassesPage(outfileName, templateName, pkg, classes, context, currentTabName, isTests);
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass) throws Exception {
        return FullHtmlReporter.renderHtmlBarTable(pcCovered, width, customClass, "", "");
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass, String customBarPositive, String customBarNegative) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("empty", pcCovered < 0.0f);
        context.put("pccovered", new Float(pcCovered));
        context.put("sortValue", new Float(pcCovered));
        context.put("width", new Integer(width));
        context.put("customClass", customClass);
        context.put("customBarPositive", customBarPositive);
        context.put("customBarNegative", customBarNegative);
        context.put("renderUtil", new HtmlRenderingSupport());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        HtmlReportUtil.getVelocityEngine().mergeTemplate("html_res/bar-graph.vm", "ASCII", context, out);
        out.close();
        return baos.toString();
    }

    private void renderPkgSummaryPage(PackageInfo pkg, TreeInfo tree, boolean siblingPagePresent, CloverExecutor queue, boolean linkToClouds) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, pkg.getName());
        queue.submit(new RenderPackageSummaryAction(context, this.mBasePath, this.mCfg, pkg, this.mDetailComparator, tree, this.mHelper, siblingPagePresent, linkToClouds));
    }

    private void renderPkgCloudPages(PackageInfo pkg, TreeInfo tree, boolean siblingPagePresent, CloverExecutor queue) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, pkg.getName());
        queue.submit(new RenderPackageCoverageCloudAction(context, this.mBasePath, tree, pkg, siblingPagePresent));
    }

    private void renderTestResultsPkgSummaryPages(PackageInfo pkg, List classes) throws Exception {
        File outdir = CloverUtils.createOutDir(pkg, this.mBasePath);
        TestMethodFilter filter = new TestMethodFilter();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            ClassInfo testClassInfo = classInfo.copy((FileInfo)classInfo.getContainingFile(), filter);
            this.renderTestClassSummaryPage(testClassInfo);
        }
        Collections.sort(classes, this.TEST_SORT_ORDER);
        File outfile = new File(outdir, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", "test-pkg-summary.html");
        this.insertCommonProps(context, pkg.getName());
        this.insertCommonTestProps(context, classes, "class", pkg, pkg, "test-pkg-summary.html", "Package", "Test Classes");
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-pkg-summary.vm");
    }

    private void renderTestClassSummaryPage(ClassInfo classInfo) throws Exception {
        String outname = this.mHelper.getTestClassLink(false, classInfo);
        File outfile = CloverUtils.createOutFile((FileInfo)classInfo.getContainingFile(), outname, this.mBasePath);
        List tests = classInfo.getTestCases();
        Collections.sort(tests, this.TEST_CASE_COMPARATOR);
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", outname);
        this.insertCommonProps(context, classInfo.getPackage().getName());
        context.put("projInfo", this.getFullModel());
        String link = this.mHelper.getTestClassLink(false, classInfo);
        this.insertCommonTestProps(context, tests, "test", classInfo.getPackage(), classInfo, link, "Class", TAB_TESTS);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-class-summary.vm");
    }

    private void insertCommonTestProps(VelocityContext context, List entities, String childEntityType, BasePackageInfo pkg, HasMetrics entity, String link, String title, String subtitle) {
        context.put("entities", entities);
        context.put("childEntityType", childEntityType);
        if (pkg != null) {
            context.put("packageName", pkg.getName());
        }
        context.put("entity", entity);
        context.put("entityLink", link);
        context.put("headerMetrics", entity.getMetrics());
        context.put("headerMetricsRaw", entity.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, entity);
        context.put("topLevel", Boolean.FALSE);
        context.put("title", title);
        context.put("subtitle", subtitle);
        context.put("hasResults", this.getTestModel().hasTestResults());
        context.put("siblingPresent", pkg == null || this.getConfiguredModel().getNamedPackage(pkg.getName()) != null);
    }

    static {
        HTML_HOMEPAGE_VALUES.put("overview", "pkg-summary.html");
        HTML_HOMEPAGE_VALUES.put("aggregate", "agg-pkgs.html");
        HTML_HOMEPAGE_VALUES.put(HTML_HOMEPAGE_DEFAULT, "dashboard.html");
        HTML_HOMEPAGE_VALUES.put("quickwins", "quick-wins.html");
        HTML_HOMEPAGE_VALUES.put("projectrisks", "proj-risks.html");
        HTML_HOMEPAGE_VALUES.put("testresults", "test-pkg-summary.html");
        SUMMARY_TABS = new LinkedHashMap();
        SUMMARY_TABS.put(TAB_CLASSES, "pkg-app.html");
        SUMMARY_TABS.put(TAB_TESTS, "pkg-test.html");
        SUMMARY_TABS.put(TAB_RESULTS, "pkg-results.html");
    }

    static class TestMethodFilter
    implements HasMetricsFilter {
        TestMethodFilter() {
        }

        public boolean accept(HasMetrics hm) {
            return !(hm instanceof MethodInfo) || ((MethodInfo)hm).isTest();
        }
    }

    public static class TreeInfo {
        private String pathPrefix;
        private String name;

        public TreeInfo(String pathPrefix, String name) {
            this.pathPrefix = pathPrefix;
            this.name = name;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getName() {
            return this.name;
        }

        public String getLowercaseName() {
            return this.name.toLowerCase();
        }

        public String toString() {
            return this.getName();
        }
    }
}

