/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.LiveCoverageRecording;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecorder;
import com_cenqua_clover.Clover;
import java.io.IOException;

public final class CoverageRecorder {
    private static final int MIN_INTERVAL = 200;
    private static final Class FORCE_THIS_TO_LOAD;
    private static final long FLUSH_INTERVAL_MASK = Integer.MAX_VALUE;
    private static final int FLUSHPOLICY_MASK = 7;
    private static final int DISABLE_SHUTDOWNHOOK_MASK = 128;
    private static final int USE_CURRENT_THREADGROUP_MASK = 256;
    private static final int DISABLE_SLICE_FLUSHING_MASK = 512;
    public static final int FLUSHPOLICY_DIRECTED = 0;
    public static final int FLUSHPOLICY_INTERVAL = 1;
    public static final int FLUSHPOLICY_THREADED = 2;
    private int[] elements;
    private PerTestRecorder testCoverage;
    private boolean flushNeeded = true;
    private long dbVersion;
    private long lastFlush = -1L;
    private String dbName;
    private final String recName;
    private final String alternateRecName;
    private int flushInterval = 0;
    private boolean useAlternate = false;
    private Thread shutdownFlusher;
    private Thread activeFlusher;
    private boolean activeFlush;
    private boolean directedOnly = false;
    private boolean shutdownHookEnabled = true;
    private boolean useCurrentThreadGroup = true;
    private boolean sliceFlushingEnabled = true;
    private boolean flushInProgress;
    private boolean keepFlushing;
    private boolean noopMode;
    private long initTS;
    private int hashcode;
    private int numElements;
    static /* synthetic */ Class class$com$cenqua$clover$CoverageRecording;

    public static long getConfigBits(long flushPolicy, int flushInterval, boolean useCurrentThreadGroup, boolean disableShutdownHook, boolean disableSlicedFlushing) {
        long result = flushInterval;
        result += flushPolicy << 32;
        if (disableShutdownHook) {
            result += 0x8000000000L;
        }
        if (useCurrentThreadGroup) {
            result += 0x10000000000L;
        }
        if (disableSlicedFlushing) {
            result += 0x20000000000L;
        }
        return result;
    }

    public CoverageRecorder(String dbName, long dbVersion, int numElements, long cfgbits) {
        this.processConfigBits(cfgbits);
        this.numElements = numElements;
        this.elements = new int[numElements];
        this.testCoverage = this.newPerSliceRecorder();
        this.dbVersion = dbVersion;
        if (this.flushInterval < 200) {
            this.flushInterval = 200;
        }
        this.dbName = dbName;
        boolean bl = this.noopMode = this.dbName == null;
        if (!this.noopMode) {
            this.hashcode = this.hashCode();
            this.initTS = System.currentTimeMillis();
            this.recName = Clover.getRecordingName(this.hashcode, dbName, this.initTS);
            this.alternateRecName = this.recName + ".1";
        } else {
            this.sliceFlushingEnabled = false;
            this.recName = null;
            this.alternateRecName = null;
        }
    }

    private PerTestRecorder newPerSliceRecorder() {
        String perTestDiff = System.getProperty("clover.pertest.coverage");
        if ("diff".equalsIgnoreCase(perTestDiff)) {
            return new PerTestRecorder.Diffing(this);
        }
        if ("off".equalsIgnoreCase(perTestDiff) || "none".equalsIgnoreCase(perTestDiff) || "false".equalsIgnoreCase(perTestDiff)) {
            return new PerTestRecorder.Null();
        }
        String perTestThreadingModel = System.getProperty("clover.pertest.coverage.threading");
        if ("volatile".equalsIgnoreCase(perTestThreadingModel)) {
            return new PerTestRecorder.Holder.Volatile(this);
        }
        if ("synchronized".equalsIgnoreCase(perTestThreadingModel)) {
            return new PerTestRecorder.Holder.Synchronized(this);
        }
        return new PerTestRecorder.Holder.SingleThreaded(this);
    }

    private void processConfigBits(long cfg) {
        this.flushInterval = (int)(cfg & Integer.MAX_VALUE);
        int cfgbits = (int)(cfg >> 32);
        int flushpolicy = cfgbits & 7;
        this.activeFlush = false;
        if (flushpolicy == 0) {
            this.directedOnly = true;
        } else if (flushpolicy == 2) {
            this.activeFlush = true;
        }
        this.useCurrentThreadGroup = (cfgbits & 0x100) != 0;
        this.shutdownHookEnabled = (cfgbits & 0x80) == 0;
        this.sliceFlushingEnabled = (cfgbits & 0x200) == 0;
    }

    public void disable() {
        this.noopMode = true;
    }

    public int[] getHits() {
        return this.elements;
    }

    public void startRun() {
        if (this.noopMode) {
            return;
        }
        int slice = Clover.getCurrentSlice();
        if (slice != -1) {
            this.sliceStart(Clover.getCurrentType(), Clover.getCurrentSliceStart(), slice, Clover.getCurrentTestRunID());
        }
        if (this.activeFlush) {
            this.activeFlusher = new CloverFlushThread(this.getTargetThreadGroup());
            this.keepFlushing = true;
            this.activeFlusher.setDaemon(true);
            this.activeFlusher.start();
            Logger.getInstance().debug("[started active flush thread for registry at " + this.dbName + ", interval= " + this.flushInterval + "]");
        }
        if (this.shutdownHookEnabled) {
            try {
                this.shutdownFlusher = new Thread(this.getTargetThreadGroup(), "CloverShutdownFlusher"){

                    public void run() {
                        if (CoverageRecorder.this.activeFlush) {
                            CoverageRecorder.this.keepFlushing = false;
                            CoverageRecorder.this.activeFlusher.interrupt();
                        }
                        CoverageRecorder.this.forceFlush(null);
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownFlusher);
                Logger.getInstance().debug("[added shutdown hook for registry at " + this.dbName + "]");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Logger.getInstance().debug("[started recorder; registry at " + this.dbName + "]");
        Logger.getInstance().debug("[integer mode; size=" + this.elements.length + "]");
    }

    private ThreadGroup getTargetThreadGroup() {
        ThreadGroup target = Thread.currentThread().getThreadGroup();
        if (this.useCurrentThreadGroup) {
            return target;
        }
        ThreadGroup parent = target;
        while (parent != null) {
            target = parent;
            parent = target.getParent();
        }
        return target;
    }

    public String getRecordingName() {
        return this.recName;
    }

    public long getDbVersion() {
        return this.dbVersion;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Thread getShutdownFlusher() {
        return this.shutdownFlusher;
    }

    public void flushNeeded() {
        this.flushNeeded = true;
    }

    public void maybeFlush() {
        if (this.directedOnly || this.activeFlush) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFlush > (long)this.flushInterval) {
            this.forceFlush();
        }
    }

    public void forceFlush() {
        this.forceFlush(Logger.getInstance());
    }

    public void flush() {
        this.flush(Logger.getInstance());
    }

    private void forceFlush(Logger logger) {
        this.flushNeeded = true;
        this.flush(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(Logger logger) {
        if (this.noopMode || !this.flushNeeded || this.flushInProgress) {
            return;
        }
        String string = this.recName;
        synchronized (string) {
            long now = System.currentTimeMillis();
            this.lastFlush = this.lastFlush >= now ? this.lastFlush + 1L : now;
            try {
                this.flushInProgress = true;
                LiveCoverageRecording.ToFile.flushToDisk(this.useAlternate ? this.alternateRecName : this.recName, this.dbVersion, this.lastFlush, this.elements);
                boolean bl = this.useAlternate = !this.useAlternate;
                if (logger != null) {
                    logger.debug("[flushed recorder \"" + this.dbName + "\" (file = \"" + (!this.useAlternate ? this.alternateRecName : this.recName) + "\", writeTimestamp = " + this.lastFlush + ", now = " + now + ")]");
                }
                this.flushNeeded = false;
            }
            catch (IOException e) {
                if (logger != null) {
                    logger.error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
                }
            }
            catch (RuntimeException e) {
                if (logger != null) {
                    logger.error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
                }
                throw e;
            }
            catch (Error e) {
                if (logger != null) {
                    logger.error(e.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + e.getMessage());
                }
                throw e;
            }
            finally {
                this.flushInProgress = false;
            }
        }
    }

    public void globalSliceStart(String runtimeType, int id) {
        this.globalSliceStart(runtimeType, id, System.currentTimeMillis());
    }

    public void globalSliceStart(String runtimeType, int id, long startTime) {
        Clover.allRecordersSliceStart(runtimeType, id, startTime);
    }

    public void globalSliceEnd(String runtimeType, String method, int id) {
        Clover.allRecordersSliceEnd(runtimeType, method, id, -1, null);
    }

    public void globalSliceEnd(String runtimeType, String method, int id, int exitStatus, Throwable throwable) {
        Clover.allRecordersSliceEnd(runtimeType, method, id, exitStatus, Clover.getErrorInfo(throwable));
    }

    public void sliceStart(String runtimeType, long ts, int id, int rid) {
        if (this.sliceFlushingEnabled) {
            this.testCoverage.testStarted(runtimeType, ts, id, rid);
        }
    }

    public void sliceEnd(String runtimeType, String method, long ts, int id, int rid, int exitStatus, ErrorInfo ei) {
        if (this.sliceFlushingEnabled) {
            this.testCoverage.testFinished(runtimeType, method, ts, id, rid, exitStatus, ei).transcribe();
        }
    }

    void growToSize(int numElements) {
        if (this.noopMode && numElements > this.numElements) {
            this.numElements = numElements;
            this.elements = new int[numElements];
        }
    }

    public int getNumElements() {
        return this.numElements;
    }

    public void rethrow(Throwable t) {
        throw t;
    }

    public void inc(int index) {
        this.testCoverage.set(index);
        int n = index;
        this.elements[n] = this.elements[n] + 1;
    }

    public int iget(int index) {
        this.testCoverage.set(index);
        int n = index;
        int n2 = this.elements[n] + 1;
        this.elements[n] = n2;
        return n2;
    }

    static {
        Class<?> clazz = class$com$cenqua$clover$CoverageRecording;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$CoverageRecording = new CoverageRecording[0].getClass().getComponentType();
        }
        FORCE_THIS_TO_LOAD = clazz;
    }

    class CloverFlushThread
    extends Thread {
        public CloverFlushThread(ThreadGroup group) {
            super(group, "CloverFlushThread");
        }

        public void requestFlush() {
            CoverageRecorder.this.forceFlush();
        }

        public void run() {
            while (CoverageRecorder.this.keepFlushing) {
                try {
                    Thread.sleep(CoverageRecorder.this.flushInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!CoverageRecorder.this.keepFlushing || System.currentTimeMillis() - CoverageRecorder.this.lastFlush < (long)CoverageRecorder.this.flushInterval) continue;
                CoverageRecorder.this.flush();
            }
        }
    }
}

