/*
 * Copyright (c) 1995, 2001, 2004 Silicon Graphics, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it would be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write the Free Software Foundation,
 * Inc.,  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __XQM_H__
#define __XQM_H__

#include <xfs/xfs.h>
#include <sys/quota.h>

/*
 * Disk quota - quotactl(2) commands for the XFS Quota Manager (XQM).
 */

#define Q_XQUOTAON	Q_QUOTAON
#define Q_XQUOTAOFF	Q_QUOTAOFF
#define Q_XGETQSTAT	Q_GETQSTAT
#define Q_XQUOTARM	Q_QUOTARM

#define qs_gquota	qs_pquota

/*
 * Warning counts are set in both super user's dquot and others. For others,
 * warnings are set/cleared by the administrators (or automatically by going
 * below the soft limit).  Superusers warning values set the warning limits
 * for the rest.  In case these values are zero, the DQ_{F,B}WARNLIMIT values
 * defined below are used. 
 * These values also apply only to the d_fieldmask field for Q_XSETQLIM.
 */
#define FS_DQ_BWARNS	(1<<9)
#define FS_DQ_IWARNS	(1<<10)
#define FS_DQ_RTBWARNS	(1<<11)
#define FS_DQ_WARNS_MASK	(FS_DQ_BWARNS | FS_DQ_IWARNS | FS_DQ_RTBWARNS)

#endif	/* __XQM_H__ */
