package developers;
use strict;

# Username to real name mapping for people who are to blame^W^W
# checking XFS mods into the xfs-kern/xfs-cmds/dmapi ptools trees.
my %names = (
	'arunr',	'Arun Ramakrishnan',
	'alkirkco',	'Mandy Kirkconnell',
	'chatz',	'David Chatterton',
	'dgc',		'David Chinner',
	'felixb',	'Felix Blyakher',
	'gnb',		'Greg Banks',
	'gwehrman',	'Geoffrey Wehrman',
	'lachlan',      'Lachlan McIlroy',
	'olaf',		'Olaf Weber',
	'nathans',	'Nathan Scott',
	'tes',		'Tim Shimmin',
	'wkendall',	'Bill Kendall',
	'yingping',	'Yingping Lu',
	'vapo',		'Vlad Apostolov',
);

sub developer_check {
	my $username = shift @_;
	if (!defined($names{$username})) {
		die "unknown developer: $username";
	}
}

sub developer {
	my $username = shift @_;
	developer_check($username);
	$names{$username} . ' <' . $username. '@sgi.com>';
}

sub developer_name {
	my $username = shift @_;
	developer_check($username);
	$names{$username};
}

sub developer_email {
	my $username = shift @_;
	developer_check($username);
	$username . '@sgi.com';
}

1;
