#!/usr/bin/perl
# bryder@sgi.com hacked this up.
# It predicts the size of an inode number in bits for an
# xfs filesystem (as at IRIX 6.5.11 anyway).
#
# It is slightly conservative in that it assumes that the entire
# disk is used for the data section which is incorrect because
# the log region (if it is internal) will use some space.
# 

use POSIX;
use Math::BigInt;

sub max_bits($) {
    my $value = Math::BigInt->new(shift @_);
    my $bitcount = 0;

    while ($value != 0){
        $value = $value / 2;
        $bitcount++;
    }
    return $bitcount;
}

$debug = 1 ;

if ($#ARGV != 3){
    print "Usage: perl inode_size.pl blocksize(bytes) inodesize(bytes) number_of_agroups(count) datablocks in filesystem(in fs blocks)\n";
    exit;
}
$blocksize=$ARGV[0];
$inodesize=$ARGV[1];
$agcount=$ARGV[2];
$datablock_count=Math::BigInt->new($ARGV[3]);

print "Blocksize: $blocksize\n";
print "Inodesize: $inodesize\n";
print "Number of allocation groups: $agcount\n";
print "Number of data blocks (in filesystem blocks) : $datablock_count\n";

print "\n";

$inopblock = $blocksize / $inodesize;
$inopblog = max_bits($inopblock-1);
print "Number of inodes in a filesystem block: $inopblock - bits: $inopblog\n";

$agblk = Math::BigInt->new(ceil($datablock_count / $agcount));
$agblklog = max_bits($agblk-1);
print "Number of datablocks in an allocation group $agblk - bits: $agblklog \n";

$agcountlog = max_bits($agcount-1);
print "Number of allocation groups: $agcount - bits: $agcountlog\n";

print "Total number of bits required  for an inode: ", $agcountlog + $agblklog + $inopblog, "\n";
