/*
 * Copyright (c) 2000-2001 Silicon Graphics, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it would be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write the Free Software Foundation,
 * Inc.,  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* Given a file object's pathname, print the object's handle. */

#include <lib/hsm.h>

#include <string.h>

/*---------------------------------------------------------------------------

Test program used to test dm_path_to_handle().  The command line is:

        path_to_handle pathname

where pathname is the name of a file, directory, or symlink.

----------------------------------------------------------------------------*/


char	*Progname;


static void
usage(void)
{
	fprintf(stderr, "usage:\t%s pathname\n", Progname);
	exit(1);
}


int
main(
	int		argc,
	char		**argv)
{
	char		*pathname;
	char		*name;
	void		*hanp;
	size_t		hlen;
	char		buffer[100];

	if (Progname = strrchr(argv[0], '/')) {
		Progname++;
	} else {
		Progname = argv[0];
	}

	if (argc != 2)
		usage();
	pathname = argv[1];

	(void)dm_init_service(&name);

	if (dm_path_to_handle(pathname, &hanp, &hlen) != 0) {
		fprintf(stderr, "dm_path_to_handle failed, %s\n",
			strerror(errno));
		return(1);
	}
	hantoa(hanp, hlen, buffer);
	fprintf(stdout, "%s\n", buffer);

	dm_handle_free(hanp, hlen);
	return(0);
}
