/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */

#include "kammu.h"
#include "kammumain.h"
#include "settings.h"
#include "sms_base.h"
#include "kammumain_base.h"
#include "getsecuritycode.h"
#include "statusbar.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <locale.h>
#include <signal.h>
#include <ctype.h>
#include <wchar.h>

#include <kdatewidget.h>
#include <kdebug.h>
#include <kfile.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kimageeffect.h>
#include <klibloader.h>
#include <klistview.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpassdlg.h>
#include <kprogress.h>
#include <kpopupmenu.h>
#include <kurl.h>
#include <kstandarddirs.h>
#include <ktempfile.h>
#include <ktimewidget.h>
#include <klineedit.h>

#include <qcheckbox.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qdir.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qstringlist.h>
#include <qtextcodec.h>
#include <qtimer.h>
#include <qvaluelist.h>
#include <qwidgetstack.h>
#include <qptrstack.h>
#include <qpixmapcache.h>
#include <qmap.h>

KammuMain::KammuMain(QWidget *parent)
        : KammuMain_base(parent)
{
    browser = new KHTMLPart( widgetStack1->widget( 0 ) );
    summaryLayout = new QGridLayout( widgetStack1->widget( 0 ) );
    summaryLayout->addWidget( browser->widget(), 1, 1 );
    connect( browser, SIGNAL( popupMenu( const QString&, const QPoint& ) ), this, SLOT( summaryContextMenu( const QString&, const QPoint& ) ) );
    connect( browser->browserExtension(), SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ), this, SLOT( openURL( const KURL & ) ) );

}

KammuMain::~KammuMain()
{}

void KammuMain::closeEvent( QEvent *event )
{
    emit signalClose( this, event );
    static_cast<QCloseEvent*>(event)->ignore();
}

void KammuMain::initPhone()
{
    config = GSM_FindGammuRC();
    kdDebug() << "[ !!! ] " << config << endl;
    s.opened=false;
    s.msg=NULL;
    s.ConfigNum=0;
    s.Config[0].Localize=NULL;

    GSM_ReadConfig( config, &s.Config[0],0 );
    s.ConfigNum++;
    error = GSM_InitConnection( &s, 3 );
    kdDebug() << error << endl;

    if( error == ERR_NONE )
    {

        if( searchtimer )
            searchtimer->stop();

        timer = new QTimer( this );
        connect( timer, SIGNAL( timeout() ), SLOT( mirrorPhone() ) );
        timer->start( 20000 );

        phone = s.Phone.Functions;
        checkSecurityStatus();
        generateSummaryHTML();
        refreshMainListView();
        updateGeneralInfo();
        mirrorPhone();
        setEnabled( true );

        if( !KammuConfig::connected() )
            KammuConfig::setConnected( true );

    }
    else
    {

        terminatePhone();
        emit signalChangeStatusbarMessage( "No mobile phone connected." );

        if( timer )
            timer->stop();

        if( !searchtimer )
        {
            searchtimer = new QTimer( this );
            connect( searchtimer, SIGNAL( timeout() ), SLOT( initPhone() ) );
            searchtimer->start( 5000 );
        }

        setEnabled( false );
        browser->write( "<h1>No mobile phone connected!</h1><hr><br>Please connect a mobile phone to your computer." );

        KammuConfig::setConnected( false );

    }
}

void KammuMain::terminatePhone()
{
    error = GSM_TerminateConnection( &s );
    kdDebug() << error << endl;
}

void KammuMain::notifyTest( int type, QString from, QString text )
{
    /* Notification types:
       1 = SMS             */

    emit signalNotification( type, from, text );
}

void KammuMain::generateSummaryHTML()
{

    char tmp[100];

    phone->GetManufacturer(&s);
    phone->GetModel(&s);

    summaryHTML =  QString( "<h1>%1 %2</h1><hr>" ).arg( s.Phone.Data.Manufacturer ).arg( s.Phone.Data.ModelInfo->model );

    summaryHTML += "<table width=100% cellspacing='7'>";

    summaryHTML += QString( "<tr><td><b>Manufacturer:</b></td><td>%1</td></tr>" ).arg( s.Phone.Data.Manufacturer );


    summaryHTML += QString( "<tr><td><b>Model:</b></td><td>%1 %2</td></tr>" ).arg( s.Phone.Data.ModelInfo->model ).arg( s.Phone.Data.Model );

    phone->GetIMEI(&s);
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>IMEI:</b></td><td>%1</td></tr>" ).arg( s.Phone.Data.IMEI );

    error=phone->GetOriginalIMEI( &s, tmp );
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>Original IMEI:</b></td><td>%1</td></tr>" ).arg( tmp );

    phone->GetFirmware(&s);
    summaryHTML += QString( "<tr><td><b>Firmware:</b></td><td>%1</td></tr>" ).arg( s.Phone.Data.Version );

    error=phone->GetHardware( &s, tmp );
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>Hardware:</b></td><td>%1</td></tr>" ).arg( tmp );

    error=phone->GetManufactureMonth( &s, tmp );
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>Original IMEI:</b></td><td>%1</td></tr>" ).arg( tmp );

    error=phone->GetProductCode( &s, tmp );
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>Product Code:</b></td><td>%1</td></tr>" ).arg( tmp );

    error=phone->GetSIMIMSI( &s, tmp );
    if (error == ERR_NONE)
        summaryHTML += QString( "<tr><td><b>SIMIMSI:</b></td><td>%1</td></tr>" ).arg( tmp );

    summaryHTML += "</tr></tbody></table>";
}


void KammuMain::checkSecurityStatus()
{
    GSM_SecurityCodeType status;
    GSM_SecurityCode c;
    phone->GetSecurityStatus( &s, &status );
    GetSecurityCode* seccode = new GetSecurityCode( this );
    seccode->setModal( true );
    QString blah;
    bool dialog = true;

    switch( status )
    {
    case SEC_SecurityCode:
        blah = "<h3>Please enter your security code</h3>";
        c.Type = SEC_SecurityCode;
        break;
    case SEC_Pin:
        blah = "<h3>Please enter your PIN code</h3>";
        c.Type = SEC_Pin;
        break;
    case SEC_Pin2:
        blah = "<h3>Please enter your PIN2 code</h3>";
        c.Type = SEC_Pin2;
        break;
    case SEC_Puk:
        blah = "<h3>Please enter your PUK code</h3>";
        c.Type = SEC_Puk;
        break;
    case SEC_Puk2:
        blah = "<h3>Please enter your PUK2 code</h3>";
        c.Type = SEC_Puk2;
        break;
    case SEC_None:
        dialog = false;
        break;
    }

    if( dialog )
    {

        seccode->show();
        seccode->label->setText( blah );

        if ( seccode->exec() == QDialog::Accepted )
        {

            strcpy( c.Code, seccode->codeLine->password() );
            c.Type = status;
            phone->EnterSecurityCode( &s, c );
        }

        else
            return;
    }

    else
        return;
}

void KammuMain::updateGeneralInfo()
{
    phone->GetModel(&s);
    phone->GetFirmware(&s);
    phone->GetManufacturer(&s);
    QString manufacturer( s.Phone.Data.Manufacturer );
    QString model( s.Phone.Data.ModelInfo->model );
    QString firmware( s.Phone.Data.Version );
    const QString& tmp( manufacturer + " " + model + " (v" + firmware + ")" );
    emit signalChangeStatusbarMessage( tmp );

}

void KammuMain::mirrorPhone()
{
    GSM_SignalQuality net;
    GSM_BatteryCharge bat;
    GSM_NetworkInfo info;
    GSM_SMSMemoryStatus	SMSStatus;
    QString tmp;

    error = phone->GetBatteryCharge( &s, &bat );

    if( error == ERR_NONE )
    {

        phone->GetNetworkInfo( &s, &info );
        phone->GetSignalQuality( &s, &net );
        phone->GetSMSStatus( &s, &SMSStatus );

        if( !info.NetworkName[ 1 ] )
            tmp = "Searching...";
        else
            tmp = QString::fromUtf8( (const char*) DecodeUnicodeConsole(&info.NetworkName[ 0 ]));
        emit signalChangeStatusbarProgress( net.SignalPercent, bat.BatteryPercent, tmp );

        if( SMSStatus.SIMUnRead == 0 && SMSStatus.PhoneUnRead == 0 )
            m_unread = "You have no new messages.";
        else
            m_unread = "<a href='sms://bleh'>You have some new messages ;)</a>";

        writeToBrowser();

    }
    else
    {

        terminatePhone();
        KammuConfig::setConnected( false );
        initPhone();
    }

}
void KammuMain::getFileSystem()
{
    fileSystemList->clear();
    folderList->clear();
    filesys.clear();
    int filenum = 0;

    //Loading icons for file types
    QPixmap imagePixmap = QPixmap("icons/image.png");
    QPixmap midiPixmap = QPixmap("icons/sound.png");
    QPixmap jarPixmap = QPixmap("icons/exec_wine.png");
    QPixmap folderPixmap =  QPixmap("icons/folder.png");
    QPixmap unknownPixmap = QPixmap("icons/unknown.png");

    //Folder filter init
    //Holds folders which are not showed in at tree
    QValueList<QString> filter;
    //    filter.append( "java SMS");
    //    filter.append( "imclient");
    //    filter.append("email");

    //Busy indicator init
    emit signalOpProgressSetup(3);
    //Private vars init
    QPtrStack<QListViewItem> stack;
    int level = 1;
    int levelPrev=1;
    bool addFlag = false;
    GSM_File file;
    QListViewItem* root = new QListViewItem(folderList , "Filesystem");
    QListViewItem* help = root;
    bool Start = true;

    //Let`s go
    for(;;)
    {
        filenum++;
        error = phone->GetNextFileFolder(&s,&file,Start);

        Start = false;
        if (error == ERR_EMPTY)
            break;

        QString filename = QString::fromLocal8Bit( (const char*) DecodeUnicodeConsole(&file.Name[ 0 ]));
        filesys[(char*)file.ID_FullName] = file;

        while (file.Level < level)
        {
            level--;
            help = stack.pop();
        }
        if (file.Folder && !file.Hidden)
        {
            level++;
            stack.push(help);
            if ( level>levelPrev && addFlag && filter.findIndex(filename.local8Bit()) == -1)
            {
                help = new QListViewItem(help,filename,(char*)file.ID_FullName);
                help->setPixmap(0,folderPixmap);
            }
            else
            {
                addFlag = true;
                levelPrev = level;
                help = new QListViewItem(help,filename,(char*)file.ID_FullName);
                help->setPixmap(0,folderPixmap);
            }
        }
        else
            if ( level>levelPrev && addFlag && filter.findIndex(filename.local8Bit()) ==-1)
            {
                QListViewItem* item = new QListViewItem(help,filename,(char*)file.ID_FullName);
                QPixmap pix;
                switch (file.Type)
                {
                case (GSM_File_Java_JAR):
                                pix = jarPixmap;
                    break;
                case (GSM_File_Image_JPG): pix = imagePixmap;
                    break;
                case (GSM_File_Image_BMP): pix = imagePixmap;
                    break;
                case( GSM_File_Image_GIF): pix = imagePixmap;
                    break;
                case(GSM_File_Image_PNG): pix = imagePixmap;
                    break;
                case( GSM_File_Image_WBMP): pix = imagePixmap;
                    break;
                case (GSM_File_Sound_MIDI):
                                pix = midiPixmap;
                    break;

                case GSM_File_Other:
                    pix = unknownPixmap;
                    if (filename.local8Bit().right(3) == "mid")
                        pix = midiPixmap;
                    break;
                default:
                    break;
                }
                item->setPixmap(0,pix);
            }
    }
    root->setOpen(true);
    emit signalOperationInProgress(3);
    qApp->processEvents();
}
/*void KammuMain::getFileSystem()
{
    bool start = true;
    GSM_File file;
    GSM_DateTime date;
    bool folder;
    int idlength;
    GSM_FileSystemStatus status;
    QString id, name, attributes;
    QDate moddate;
    QTime modtime;
    QListViewItem *fileitem, *folderitem;
    filesys.clear();
    //parent->m_statusbar->opProgress->setTotalSteps(3);
    //parent->m_statusbar->opProgress->setProgress(0);
    
    while( 1 ) {
        
        if( error == ERR_EMPTY ) break;
        attributes = "";
        folder = false;
        error = phone->GetNextFileFolder( &s, &file, start );
        
        idlength = strlen( (const char*) file.ID_FullName );
                    
        if( ( idlength < 5 ) && ( idlength != 0) ) {
        
            id = QString::fromUtf8( (const char*) file.ID_FullName, idlength );
            name = QString::fromUtf8( (const char*) DecodeUnicodeConsole( file.Name ) );
            //fsize = QString::fromUtf8( (const char*) file.Used );
            //size crashes kammu... TODO check with other phones
            //works fine with the cli-gammu though... 
            if( !file.ModifiedEmpty ) date = file.Modified;
            
            moddate.setYMD( date.Year, date.Month, date.Day );
            modtime.setHMS( date.Hour, date.Minute, date.Second );
 
            // TODO subfolders (file.Level) 
                                                
            if ( file.Folder && file.System && !file.Hidden ) {
               
                folderitem = new QListViewItem( fileSystemList, name );
                folderitem->setText( 0, name );
                folderitem->setText( 1, attributes );
                folderitem->setText( 2, id );
                folderitem->setText( 3, "folder" );
                folderitem->setExpandable( true );
                folderitem->setOpen( true );
                folderitem->setPixmap( 0, SmallIcon( "folder" ) );
                                              
           } else if ( !file.Folder ) {
                            
                fileitem = new QListViewItem( folderitem, name );
                fileitem->setText( 0, name );
                fileitem->setText( 1, moddate.toString( "yyyy-MM-dd" ) + " " + modtime.toString( "hh-mm" ) );
                fileitem->setText( 2, id );
                fileitem->setText( 3, "file" );
                fileitem->setPixmap( 0, SmallIcon( "empty" ) );
                folderitem->insertItem( fileitem );
                
            }
         }
  
        start = false;
    }
}
*/

void
KammuMain::refreshMainListView()
{

    GSM_SMSFolders folders;
    QString folderlist, foldername;
    int i;
    QPixmap icon;

    mainListView->clear();

    QListViewItem * tmpitem = new QListViewItem( mainListView, 0 );
    tmpitem->setText( 0, i18n( "Phone" ) );
    tmpitem->setPixmap( 0, SmallIcon( "kmobiletools" ) );
    tmpitem->setOpen( true );
    QListViewItem * tmpitem1 = new QListViewItem( tmpitem, 0 );
    tmpitem1->setText( 0, i18n( "Addressbook" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "kontact_contact" ) );
    tmpitem1->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "Calendar" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "kontact_date" ) );
    tmpitem1->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "Filesystem" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "folder" ) );
    tmpitem1->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "Logos" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "colors" ) );
    tmpitem1->setOpen( true );
    QListViewItem * tmpitem2 = new QListViewItem( tmpitem, tmpitem );
    tmpitem2->setText( 0, i18n( "Messages" ) );
    tmpitem2->setPixmap( 0, SmallIcon( "kontact_mail" ) );
    tmpitem2->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem2, tmpitem1 );
    tmpitem1->setText( 0, i18n( "MMS" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "kmenu" ) );
    tmpitem2->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem2, tmpitem1 );
    tmpitem1->setText( 0, i18n( "SMS" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "kmenu" ) );

    phone->GetSMSFolders(&s,&folders);

    for ( i=0; i < folders.Number; i++ )
    {

        foldername = QString::fromUtf8( (const char*) DecodeUnicodeConsole( (unsigned char*) folders.Folder[i].Name ) );
        i + 1;

        switch(folders.Folder[i].Memory)
        {

        case MEM_SM:
            icon = SmallIcon( "no" );
            break;

        case MEM_ME:
            icon = SmallIcon( "kmobiletools" );
            break;

        case MEM_MT:
            icon = SmallIcon( "no" );
            break;
        }

        QListViewItem * tmpitem3 = new QListViewItem( tmpitem1, tmpitem1 );
        tmpitem3->setText( 0, foldername );
        tmpitem3->setText( 1, "sms" );
        tmpitem3->setPixmap( 0, icon );
        tmpitem3->setOpen( true );
    }

    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "Phone settings" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "configure" ) );
    tmpitem1->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "Ringtones" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "folder_sound" ) );
    tmpitem1->setOpen( true );
    tmpitem1 = new QListViewItem( tmpitem, tmpitem );
    tmpitem1->setText( 0, i18n( "ToDo" ) );
    tmpitem1->setPixmap( 0, SmallIcon( "kontact_todo" ) );

}

void
KammuMain::changePage( QListViewItem* item )
{
    if( item )
    {

        if( item->text( 0 ) == "Phone" )
            widgetStack1->raiseWidget( 0 );
        else if( item->text( 0 ) == "Addressbook" )
            widgetStack1->raiseWidget( 1 );
        else if( item->text( 0 ) == "SMS" )
            widgetStack1->raiseWidget( 2 );
        else if( item->text( 0 ) == "Filesystem" )
            widgetStack1->raiseWidget( 3 );
        else if( item->text( 0 ) == "Calendar" )
            widgetStack1->raiseWidget( 4 );
        else if( item->text( 0 ) == "ToDo" )
            widgetStack1->raiseWidget( 5 );
        else if( item->text( 0 ) == "Phone settings" )
        {

            widgetStack1->raiseWidget( 6 );
            getDateTime();
            getAlarm();
        }
        else if( item->text( 0 ) == "Calendar" )
            widgetStack1->raiseWidget( 7 );
        else if( item->text( 0 ) == "Ringtones" )
            widgetStack1->raiseWidget( 7 );
        else if( item->text( 0 ) == "Logos" )
            widgetStack1->raiseWidget( 9 );
        else if( item->text( 0 ) == "Messages" )
            widgetStack1->raiseWidget( 10 );
        else if( item->text( 0 ) == "MMS" )
            widgetStack1->raiseWidget( 11 );
        else if( item->text( 1 ) == "sms" )
            widgetStack1->raiseWidget( 2 );
    }
}

void
KammuMain::fileContextMenu( QListViewItem* item, const QPoint& point ,int) //SLOT
{
    QString tmp;
    KPopupMenu menu( this );
    KURL saveas;
    QDir savefolder;
    enum Actions { SAVEFOLDER, CLEARFOLDER, SAVEFILE, DELETEFILE };

    if( item->text( 0 ).endsWith( "/" ) )
    {

        menu.insertItem( i18n( "Save folder" ), SAVEFOLDER );
        menu.insertItem( i18n( "Clear folder" ), CLEARFOLDER );

    }
    else
    {

        menu.insertItem( i18n( "Save file" ), SAVEFILE );
        menu.insertItem( i18n( "Delete file" ), DELETEFILE );
    }

    switch( menu.exec( point ) )
    {

    case SAVEFOLDER:

        saveas = KFileDialog::getSaveFileName( ":homedir", item->text( 0 ), this, "Save file" + item->text( 0 ) );

        savefolder = saveas.directory() + "/" + item->text( 0 );

        if( !savefolder.exists() )
            savefolder.mkdir( savefolder.absPath(), true );

        savefolder.cd( savefolder.absPath(), true );

        /* TODO save folder */


        break;
    case CLEARFOLDER:
        return;
        break;
    case SAVEFILE:

        saveas = KFileDialog::getSaveFileName( ":homedir", item->text( 0 ), this, "Save file" + item->text( 0 ) );

        break;
    case DELETEFILE:

        int really( KMessageBox::warningYesNo( this, "Do you really want to delete" + item->text( 0 ), "Confirmation - shrug" ) );

        if( really == KMessageBox::Yes )
        {

            proc = new QProcess (this);
            proc->addArgument( "gammu" );
            proc->addArgument( "--deletefiles");
            proc->addArgument( item->text( 4 ) );
            proc->start();
            fileSystemList->takeItem( item );
            connect( proc, SIGNAL( processExited() ), this, SLOT( gammuDone() ) );
        }
        break;
    }
}

void
KammuMain::smsContextMenu( QListViewItem* item, const QPoint& point ) //SLOT
{
    QString tmp;
    KPopupMenu menu( this );
    KURL saveas;
    QDir savefolder;
    enum Actions { DELETESMS, REPLY };

    menu.insertItem( i18n( "Save folder" ), DELETESMS );
    menu.insertItem( i18n( "Clear folder" ), REPLY );

    switch( menu.exec( point ) )
    {

    case DELETESMS:
        break;
    case REPLY:
        break;
    }
}

void
KammuMain::summaryContextMenu( const QString &url, const QPoint &point ) //SLOT
{
    QString tmp;

    enum Actions { DELETESMS, REPLY };

    if( url )
    {

        KPopupMenu menu( this );
        menu.insertItem( i18n( "Save folder" ), DELETESMS );
        menu.insertItem( i18n( "Clear folder" ), REPLY );

        switch( menu.exec( point ) )
        {

        case DELETESMS:
            break;
        case REPLY:
            break;
        }
    }
}

void KammuMain::openURL( const KURL & url )
{
    if( url.protocol() == "sms" )
    {

        kdDebug() << "yay, sms. " << endl;
        widgetStack1->raiseWidget( 2 );
    }

    if( url.protocol() == "missedcall" )
    {

        kdDebug() << "yay, missed call. " << endl;
    }

    if( url.protocol() == "appointment" )
    {

        kdDebug() << "yay, appointment. " << endl;
    }

    if( url.protocol() == "todo" )
    {

        kdDebug() << "yay, todo. " << endl;
    }

}

void KammuMain::smsClicked( QListViewItem* item )
{
    QString folder( item->text( 3 ) );
    QString from( item->text( 0 ) );
    QString sent( item->text( 5 ) );
    QString text( item->text( 4 ) );

    smsText->setText( "<b>Folder: </b>" + folder + "<br><b>From: </b>" + from + "<br><b>Date: </b>" + sent + "<br><br><hr><br><font size='+2'>" + text + "</font>" );
}

void KammuMain::newSms()
{
    SMS_base* sms = new SMS_base();
    sms->show();

}

void KammuMain::getDateTime()
{
    GSM_DateTime date_time;
    GSM_Locale locale;
    QDate date;
    QTime time;

    error = phone->GetDateTime(&s, &date_time);

    if( error == ERR_NONE )
    {

        date.setYMD( date_time.Year, date_time.Month, date_time.Day );
        time.setHMS( date_time.Hour, date_time.Minute, date_time.Second );
        timeWidget->setTime( time );
        dateWidget->setDate( date );
    }
}

void KammuMain::setDateTime()
{
    GSM_DateTime date_time;
    QDate date( dateWidget->date() );
    QTime time( timeWidget->time() );

    date_time.Year = date.year();
    date_time.Month = date.month();
    date_time.Day = date.day();
    date_time.Hour = time.hour();
    date_time.Minute = time.minute();
    date_time.Second = time.second();

    phone->SetDateTime(&s, &date_time);
}

void KammuMain::getAlarm()
{
    GSM_Alarm alarm;
    QTime time;

    alarm.Location = 1;

    error = phone->GetAlarm(&s, &alarm);

    if( error == ERR_NONE )
    {

        alarmCheckBox->setChecked( true );
        alarmWidget->setEnabled( true );

        time.setHMS( alarm.DateTime.Hour, alarm.DateTime.Minute, 0 );

        alarmWidget->setTime( time );
    }
    else
    {

        alarmCheckBox->setChecked( false );
        alarmWidget->setEnabled( false );
    }
}

void KammuMain::setAlarm()
{
    GSM_Alarm alarm;
    QTime time( alarmWidget->time() );

    alarm.DateTime.Hour = time.hour();
    alarm.DateTime.Minute = time.minute();
    alarm.DateTime.Second = 0;
    alarm.Location = 1;
    alarm.Repeating = true;
    alarm.Text[0] = 0;
    alarm.Text[1] = 0;

    phone->SetAlarm(&s, &alarm);
}

void KammuMain::getRingtonesList()
{
    QListViewItem *folderitem;
    GSM_AllRingtonesInfo info;
    int i;
    QString name;

    error=phone->GetRingtonesInfo( &s, &info );

    for ( i=0; i < info.Number; i++ )
    {

        name = QString::fromUtf8( (const char*) DecodeUnicodeConsole( (unsigned char*) info.Ringtone[i].Name ) );
        folderitem = new QListViewItem( ringtonesListView, name );
        folderitem->setText( 0, name );
        folderitem->setPixmap( 0, SmallIcon( "kmix" ) );
    }
}

void KammuMain::writeToBrowser()
{
    QFont font = KammuConfig::summaryFont();

    browser->setStandardFont( font.family() );
    setStyleSheet();
    browser->begin();
    browser->setUserStyleSheet( stylesheet );
    browser->write( "<html>" );
    browser->write( QString(

                        "<div class='area1'>"
                        "<table width='100%' height='90%'>"
                        "<tr><td valign='top'>%1</td></tr>" // this is the summaryHTML
                        "</table><br>"
                        "</div>"

                        "<div class='rbcontent'><div class='area2'>"
                        "<table width='100%'>"
                        "<thead><tr><th align='left'>Missed calls</th></tr></thead>"
                        "<tbody>"
                        "<tr><td class='song'><a href='missedcall://bleh'>You have no missed calls.</a></td></tr>"
                        "</tbody></table><br>"

                        "<table width='100%'>"
                        "<thead><tr><th align='left'>New Messages</th></tr></thead>"
                        "<tbody>"
                        "<tr><td class='song'>%2</td></tr>"
                        "</tbody></table><br>"

                        "<table width='100%'>"
                        "<thead><tr><th align='left'>Appointments</th></tr></thead>"
                        "<tbody>"
                        "<tr><td class='song'><a href='appointment://bleh'>You have no appointments.</a></td></tr>"
                        "</tbody></table><br>"

                        "<table width='100%'>"
                        "<thead><tr><th align='left'>Todos</th></tr></thead>"
                        "<tbody>"
                        "<tr><td class='song'><a href='todo://bleh'>Fix kammu!</a></td></tr>"
                        "</tbody></table>"
                        "</div>"

                    ).arg( summaryHTML ).arg( m_unread ) );

    browser->write( "</html>" );
    browser->end();
}

void KammuMain::setStyleSheet()
{
    QFont font      = KammuConfig::summaryFont();
    QColor text     = KammuConfig::summaryFontColor();
    QColor fg       = KammuConfig::summaryForegroundColor();
    QColor bg       = KammuConfig::summaryBackgroundColor();
    QColor gradient = KammuConfig::summaryGradientColor();

    int pxSize = font.pointSize();
    browser->setStandardFont( font.family() );

    /* writing temp gradient image */
    tempfile = new KTempFile( locateLocal( "tmp", "gradient" ), ".png", 0600 );
    QImage image = KImageEffect::gradient( QSize( 600, 1 ), gradient, gradient.light(), KImageEffect::PipeCrossGradient, 3 );
    image.save( tempfile->file(), "PNG" );
    tempfile->close();

    /* we have to set the color for body due to a KHTML bug
       KHTML sets the base color but not the text color */
    stylesheet  = QString( "body { margin: 8px; font-size: %1px; color: %2; background-color: %3; background-image: url( %4 ); backgroud-repeat: repeat-y; }" ).arg( pxSize ).arg( text.name() ).arg( gradient.name() ).arg( tempfile->name() );

    stylesheet += QString( "div.area1 { position: absolute; top: 5%; width: 70%; height: 90%; border-style: solid; border-width: 1px; border-color: #808080; }" );

    stylesheet += QString( "div.area2 { position: absolute; top: 5%; right: 2%; width: 25%; height: 90%; }" );

    stylesheet += QString( "a { font-size: %1px; color: %2; }" ).arg( pxSize ).arg( text.name() );

    stylesheet += QString( ".menu { color: %1; background-color: %2; margin: 0.4em 0.0em; font-weight: bold; }" ).arg( fg.name() ).arg( bg.name() );

    /* set background for all tables */
    stylesheet += QString( "table { background-color: %1; }" ).arg( colorGroup().base().name() );

    /* header for all sections */
    stylesheet += QString( "th { text-align: left; color: %1; font-size: %2px; font-weight: bold; background-color: %3; padding: 1px 0.5em; border-bottom: 1px solid #000; }" ).arg( fg.name() ).arg( pxSize + 1 ).arg( bg.name() );

    stylesheet += QString( "td { text-align: left; font-size: %1px; }" ).arg( pxSize );

    /* this is the style for the other blocks */
    stylesheet += QString( ".rbcontent { border: solid %1 1px; }" ).arg( bg.name() );

    stylesheet += QString( ".rbcontent:hover { border: solid %1 1px; }" ).arg( text.name() );

    stylesheet += QString( ".rbcontent a { text-decoration: none; }" );

    stylesheet += QString( ".rbcontent .song a { display: block; padding: 1px 2px; }" );

    stylesheet += QString( ".rbcontent .song a:hover { color: %1; background-color: %1; }" ).arg( fg.name() ).arg( bg.name() );

    stylesheet += QString( ".rbcontent .rbalbum:hover { background-color: %1; cursor: pointer; }" ).arg( bg.name() );

    stylesheet += QString( ".rbcontent .rbalbum:hover a { color: %1; }" ).arg( fg.name() );

    browser->setUserStyleSheet( stylesheet );
}


#include "kammumain.moc"

void KammuMain::folderListClicked(QListViewItem* item)
{
    if (item)
    {
        GSM_File file = filesys[item->text(1)];
        if (file.Folder)
        {
            fileSystemList->clear();
            fileSystemList->setColumnWidth(0,70);
            QListViewItem * child = item->firstChild();
            while( child )
            {
                file = filesys[child->text(1)];
                switch (file.Type)
                {
                case GSM_File_Sound_MIDI:
                    addToFileListMIDI(child);
                    break;

                case GSM_File_Image_JPG:
                case GSM_File_Image_PNG:
                case GSM_File_Image_GIF:
                case GSM_File_Image_BMP:
                    addToFileListImage(child);
                    break;

                case GSM_File_Other:
                    {
                        if (child->text(0).right(3) == "mid")
                            addToFileListMIDI(child);

                        if (child->text(0).right(3) == "jpg" || child->text(0).right(3) == "gif")
                            addToFileListImage(child);
                    }
                default:
                    break;
                }
                child = child->nextSibling();
            }
        }
    }
}

void KammuMain::addToFileListMIDI(QListViewItem* lvi)
{
    QListViewItem* item = new QListViewItem(fileSystemList);
    item->setPixmap(0,QPixmap("icons/midi2.png"));
    item->setText(1,lvi->text(0));
}

void KammuMain::addToFileListImage(QListViewItem* lvi)
{
    GSM_File file =filesys [lvi->text(1)];
    QPixmap p;
    if (!QPixmapCache::find(lvi->text(0)+lvi->text(1),p))
    {
        readFile(lvi->text(1),&file);
        QByteArray ba;
        ba.setRawData((char*)file.Buffer,file.Used);
        QImage img(ba);
        img = img.smoothScale(64,64,QImage::ScaleMin);
        p = QPixmap(img);
        QPixmapCache::insert(lvi->text(0)+lvi->text(1),p);
    }
    QListViewItem* item = new QListViewItem(fileSystemList);
    item->setPixmap(0,p);
    item->setText(1,lvi->text(0));
}

void KammuMain::readFile(QString name, GSM_File* file)
{
    file->Used=0;
    bool start=true;

    if (file->Buffer != NULL)
    {
        //        free(file->Buffer);// FIXME:Unexpected crash
        file->Buffer = NULL;  //   FIXME:Memory leak  :(
    }

    error = ERR_NONE;
    while (error == ERR_NONE)
    {
        error = phone->GetFilePart(&s,file);
        if (error == ERR_NONE || error == ERR_EMPTY || error == ERR_WRONGCRC)
        {
            if (start)
                start = false;

            if (error == ERR_EMPTY)
                break;
        }
    }
}
