/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */

#ifndef KAMMU_STATUSBAR_H
#define KAMMU_STATUSBAR_H


#include <kstatusbar.h>     //baseclass
#include <qevent.h>         //baseclass
#include <qlabel.h>         //baseclass
#include <qlayout.h>
#include <qhbox.h>
#include <ksqueezedtextlabel.h>

class KAction;
class KProgress;
class KToggleAction;
class QCustomEvent;
class QTimer;


class StatusBar : public KStatusBar
{
    Q_OBJECT
public:
    StatusBar( QWidget *parent = 0, const char *name = 0 );
    ~StatusBar();

public slots:
    void message( const QString& message ); //reimpl. from QStatusBar
    void progress( int net, int bat, QString network );
    void messageTemporary( const QString& message );
    void restore();
    void clear(); //reimpl. from QStatusBar

    static const int TEMP_MESSAGE_DURATION = 5000; //msec
    static StatusBar* s_instance;

    QLabel         *netLabel;
    QLabel         *batLabel;
    QLabel         *netName;
    KSqueezedTextLabel *messageLabel;
    KProgress      *netProgress;
    KProgress      *batProgress;
    KProgress	*opProgress;
    QString        oldMessage;
    QHBox          *box;

};

#endif
