#!/bin/bash

set -o errexit

# This tool helps to prepare your file for upload.
# You should have the edited file ready.

if ! test "$#" -ne 3 ; then
	echo "Usage: $0 project_name_without_leading_\"yast-\" language_code edited_filename.po"
fi
PROJECT=$1
LNG=$2
REVIEW=$3

WEBLATE_FILE=merge-tool-$PROJECT-$LNG-weblate.po
FTP_TEMP=merge-tool-$PROJECT-$LNG

curl https://l10n.opensuse.org/download/yast-$PROJECT/master/$LNG/ >$WEBLATE_FILE
curl ftp://ftp.suse.com/pub/people/sbrabec/yast-translations-sle-contributions/$PROJECT/$LNG.po >$FTP_TEMP-ftp.po

# Generate file in a fuzzy-changes form
msgcat $FTP_TEMP-ftp.po $REVIEW -o $FTP_TEMP-revshow.po
# Extract changed strings using that file
msgcat --use-first --unique $REVIEW $FTP_TEMP-revshow.po -o $FTP_TEMP-changed.po
# And now inject these changed strings to Weblate
msgcat --use-first $FTP_TEMP-changed.po $WEBLATE_FILE -o $FTP_TEMP-final.po
# And merge with the latest po to remove possible obsolete strings.
# (Normally msgmerge uses pot file, but merge withe po file is easier here.)
msgmerge --silent --previous --lang=$LNG $FTP_TEMP-final.po $WEBLATE_FILE -o $PROJECT-$LNG-upload.po

# And remove temporary files
rm $FTP_TEMP-*.po

echo ""
echo "Merged. Please upload $PROJECT-$LNG-upload.po to Weblate:"
echo "https://l10n.opensuse.org/projects/yast-$PROJECT/master/$LNG/#upload"
