.TH drvmidi 1 "January 16, 2000"
.LO 1
.SH NAME
drvmidi \- AWE32 MIDI player
.SH SYNOPSIS
drvmidi [options] midifile[.gz]..
.SH DESCRIPTION
.B drvmidi
is a MIDI player program which supports AWE32 sound driver
by Takashi Iwai.
Before using this program, you have to load sound
samples onto the driver (see sfxload(1)).

You can give the compressed or gzipped files on command line.
These files are expanded automatically inside the program.
The new drvmidi accepts not only normal MIDI files, but also RIFF
combined MIDI files and CMF files.

If drvmidi finds a file which has the same file name with the
extension ".id", drvmidi reads this file as an option file.  You can
specify its own settings without the command line options.  See
"option file format" section for the syntax of the option file.  The 
option file is editable via File/Edit Options menu in tkmidi(1).

Ver.0.4.3 can emulate XG MIDI with GS soundfont samples.  You need
to load XG SFX and drum maps for this emulation together with --xgmap
option to play properly XG sounds.

.SH "DYNAMIC SOUNDFONT LOADING"

The dynamic soundfont loading is helpful for users who have only
limited DRAM on the soundcard.  If the dynamic loading is enabled,
drvmidi loads the specified soundfont or virtual bank file
automatically when it receives each MIDI file.
Since only necessary samples are loaded, the required memory size of
soundcard is reduced.  For example, 2MB GS font can be used on 512KB
RAM in most of MIDI files.

In the case of XG midi file, specify the font file via --xgload
option.  The specified file should contain proper XG mappings, and
GS font file as default font.  Usually, this option should be used
together with --xgmap option.
In other cases, the font file specified in --dynamic option is used as
the dynamic font file.  In both cases, the specified file can be a
soundfont file or a virtual bank file.  The virtual bank file can
define each preset from various soundfont files, and preset mappings.
See the description in awesfx utility for more details.


.SH OPTIONS
.TP
.B \-i, --interface=type
Specify the user interface mode.
.I k
for Tcl/Tk interface, and 
.I d
for dumb interface.
.I n
means ncurses interface.
The default is Tcl/Tk interface.
.TP
.B \-D, --drum=channel
Change drum channels.
If
.I channel
is a positive value, this channel is treated as a drum channel.
If a negavive value, minus of this value is treated as a normal channel.
For example,
.in +4

% drvmidi --drum=-10 --drum=16 foo.mid

.in -4
will set channel 10 as a normal channel, and channel 16 as
a drum one.
As default, drvmidi uses only channel 10 (and 26) as drum channels.
.TP
.B \--drumflag=val
Set all drum channels as 32bit flags.  For example, the argument
0x02008200 will set channel 10, 16, and 26 as drum channels. 
.TP
.B \-c, --chorus=mode
Specify the chorus mode.  The AWE32 card has eight chorus modes as default.
The other modes can be defined via setfx(1) utility program.
The system default modes are:
.in +4

0: chorus 1
.br
1: chorus 2
.br
2: chorus 3
.br
3: chorus 4
.br
4: feedback
.br
5: flanger
.br
6: short delay
.br
7: short delay 2
.in -4

On Tcl/Tk interface, these values can be changed from menu even during
playing samples.
The chorus/reverb mode specified in this option may be changed
by sysex control in MIDI file.
.TP
.B \-r, --reverb=mode
Specify the reverb mode.  The AWE32 card has eight reverb modes as default.
The other modes can be defined via setfx(1) utility program.
The systetm default modes are:
.in +4

0: room 1
.br
1: room 2
.br
2: room 3
.br
3: hall 1
.br
4: hall 2
.br
5: plate
.br
6: delay
.br
7: panning delay
.in -4

On Tcl/Tk interface, these values can be changed from menu even during
playing samples.
The chorus/reverb mode specified in this option may be changed
by sysex control in MIDI file.
.TP
.B \--chorusdepth=val
Define the default chorus depth.
This value is not used when chorus value (CC #93) is defined in each MIDI
file.  The argument is an integer from 0 to 127.
.TP
.B \--reverbdepth=val
Define the default reverb depth.
This value is not used when reverb value (CC #91) is defined in each MIDI
file.  The argument is an integer from 0 to 127.
.TP
.B \-V, --volume=percent
Set the master volume in percent unit.  Default is 100.
.TP
.B \-S, --volscale=percent
Set volume scaling factor.  The argument is in percent.
It still accepts a float number from 0 to 5.0 for
compatibility with older version.  For example, if a number
0.8 is given, the MIDI volume will be output in 80% of the
normal scale.   
Default factor is 100.
.TP
.B \--bass=val
Define the equalizer bass level of AWE driver,
The value is from 0 (\-12 dB) to 11 (+12 dB).
.TP
.B \--treble=val
Define the equalizer treble level of AWE driver,
The value is from 0 (\-12 dB) to 11 (+12 dB).
.TP
.B \-O, --aceptall[=bool]
Toggle to accpept or ignore
.I "all notes off"
and
.I "all sounds off"
events.
Some MIDI file contains these events.
Either of "on", "off", "yes", "no", "true", or "false", "0" or "1"
can be specified as an optional boolean argument.
Default is ON.
.TP
.B \-P, --realpan[=bool]
Toggle to enable or disable realtime panning change.
Emu8000 chip often causes a click noise when changing the panning position
in real time during playing a voice.
Default is ON.
.TP
.B \--multipart[=bool]
Toggle to enable or disable multi MIDI parts.
If this option is enabled, the the tracks later than the given track number
are treates as MIDI part B.
Note that even if this option is disabled, multi mode is activated when
GS multi mode sysex is received (see SYSEX MACROS section).
Default is OFF.
.TP
.B \-T, --tracks=num
Specify the track number of multi part.  For example, to deal with tracks
from 0 to 16 as part A, and from 17 to 32 as part B, specify "--tracks=16".
The value -1 means to disable multi MIDI parts (equivalent with --multipart=off).
The default value is 16.
.TP
.B \-M, --mt32=mode
Set MT32 program mode.  The argument must be from 0 to 2.
When mode is 0, no conversion is done (GM/GS mode).  When 1 is 
given, bank number 127 is automatically set.  If you have a
proper MT-32 set, you should specify 1.  Otherwise, when the
argument is 2, each preset number is converted internally to
the corresponding GM preset number.
Default is 0.
.TP
.B \-C, --samecsec[=bool]
Toggle to enable or disable the note-off event check.
The sequencer device can handle events only in 1/100 sec unit,
so often both the note on and off events occur at the same time.
To prevent this problem, drvmidi checks the time of each note off event,
and send it after 1/100 sec later if necessary.
Default is ON.
.TP
.B \-G, --gsmacro[=bool]
Toggle to enable or disable GS sysex controls.
When GS part check is on, drvmidi accepts chorus mode, reverb
mode, and GS part change messages.
Default is ON.
.TP
.B \-X, --xgmacro[=bool]
Toggle to enable or disable XG bank controls.
Default is ON.
.TP
.B \-N, --increment[=bool]
Load the fonts incrementally.  This option enables the sample
sharing on awedrv-0.4.3, and reduces the loading time.  If
you're using 12MB fonts on 8MB DRAM, it's better to set this
option.  If you have 512k DRAM, better to disable this option.
Default is ON.
.TP
.B \--xgmap=bool
Control XG SFX and drum mapping.  If this option is enabled,
bank #64 and #126 are used for XG SFX sounds.  XG drumsets are
shifted from #64 to #126 to avoid conflicts with GS sounds.
To support this mapping, you need to load XG map file on AWE
drvier.  The --xgload option below is helpful for dynamic
loading of this map file.
.TP
.B \--xgload=file
Set the font file to load automatically when drvmidi receives
a XG midi file.  This just behaves as --dynamic option, but
invoked only when the MIDI file is XG.
If "none" is specified as the argument, this function is
suppressed. 
.TP
.B \-s, --autoskip[=bool]
Toggle auto skip mode.
If this option is enabled, drvmidi skips
to the first note on event immediately after starting.
Default is OFF.
.TP
.B \--chnprior[=bool]
Enable or disable MIDI channel proprity mode.
If this is enabled, the drum channels have the highest priority,
and the lower channels have higher priority.  A new voice is
allocated from the channel with lower priority.  This
mechanism is available only on GS or XG mode.
Default is OFF.
.TP
.B \-L, --dynamic=fontfile
Load the specified soundfont file automatically.
If this option is enabled, drvmidi invokes sfxload(1) program to
load soundfont (or virtual bank) file on the driver.
If "none" is specified as the argument, this function is
suppressed. 
.TP
.B \-v, --verbose[=level]
Increase or set the verbosity level.
.TP
.B \--parsetitle[=bool]
Toggle to enable or disable to display the first text event as a title.
Default is ON.
.TP
.B \-m, --mode=modifiers
Set playing mode.  Some modes are valid only on Tcl/Tk interface.
The following mode identifiers may be available:
.RS
.TP
.B t
Turn tracing mode on.  It shows realtime bar graph and program number of
each channel in the trace window.
.TP
.B s
Shuffle play mode.  The order of the playing songs is shuffled and selected
randomly.
.TP
.B n
Normal play mode.  The songs are played in the order of specified command line arguments.
.TP
.B p
Start play automatically.
.TP
.B q
Exit drvmidi automatically after finishing all songs.
.TP
.B r
Loop the playing song.
.RE
.TP
.B \-t, --trace
Turn tracing mode on.  Equivalent with
.B \-mt.
.TP
.B \-d, --display=xdisp
Set window display.  Valid only on Tcl/Tk interface.
.TP
.B \-g, --geometry=xgeom
Set window geometry.  Valid only on Tcl/Tk interface.
.TP
.B \--newvolume[=file]
Use the new volume calculation which is compatible with Win/DOS
drivers.  Default is ON.
.TP
.B \--effect=file
Set user defined chorus/reverb configurations.  Valid only on
Tcl/Tk interface.
.TP
.B \--convert=ext/converter
Define new file conversion rule for the specified file
extension.  The argument gives both file extension and the
converter program separated by slash letter.  The converter
program must read the source file from stdin and output a MIDI
format to stdout.  For example, to convert .rcp file to midi
format via rcptomid program automatically, set the option as
follows:
.in +1i
--convert=rcp/rcptomid
.in -1i
Also, to accept the gzipped file, too, define the following
with addition to the above one:
.in +1i
--convert="rcp.gz/zcat %s | rcptomid"
.in -1i
The %s is replaced with the corresponding source file name.
.TP
.B \--usefx=bool
Enable or disable effect controls.  This feature is still
experimental.  When this option is enabled, drvmidi emulates
SC88 NRPN (TVF/EG parameters) and AWE32 NRPN controls in GM/GS 
mode, and accepts hermonic (cc#71), brightness (cc#74), attack 
and release time (cc#72 and #73) in XG mode.
.TP
.B \--fx_cutoff=int
Change TVF cut-off parameter sensitivity.  Valid only when
usefx option is set.  Default value is 170.
.TP
.B \--fx_resonance=int
Change TVF resonance parameter sensitivity.  Valid only when
usefx option is set.  Default value is 6.
.TP
.B \--fx_attack=int
Change EG attack time sensitivity.  Valid only when usefx
option is set.  Default value is 50.
.TP
.B \--fx_release=int
Change EG release time sensitivity.  Valid only when usefx
option is set.  Default value is 50.
.TP
.B \--fx_vibrate=int
Change vibrato rate sensitivity.  Valid only when usefx
option is set.  Default value is 30.
.TP
.B \--fx_vibdeepth=int
Change vibrato depth sensitivity.  Valid only when usefx
options is set.  Default value is 4.
.TP
.B \--fx_vibdelay=int
Change vibrato delay sensitivity.  Valid only when usefx
options is set.  Default value is 1500.
.TP
.B \--seqdev=file
Specify the OSS sequencer device file to be used.
The default value is /dev/sequencer.
.TP
.B \--seqidx=val
Specify the device number index of AWE driver.  If a negative
value is given, the device is probed and the first matching
device will be selected.  If multiple AWE driver is installed,
you'll need to specify the appropriate one.
Default value is -1.
.TP
.B \--seqbuf=bool
Enable or disable the buffered output to sequencer device.
See event handling section for more details.
Default is ON.
.TP
.B \--seqecho=bool
Enable or disable the timer synchronization via echo back from 
sequencer device.  See event handling section for more details.
Default is ON.

.SH "OPTION FILE FORMAT"
.TP
.B "title string"
Set title of this midi file.  Displayed on behalf of the file name.
.TP
.B "parsetitle bool"
Enable or suppress to parse the title string from MIDI file automatically.
.TP
.B "chorus mode"
Set chorus mode.  The argument is identical with the option --chorus.
.TP
.B "reverb mode"
Set reverb mode.  The argument is identical with the option --reverb.
.TP
.B "chorusdepth value"
Set default chorus depth.  The argument is identical with the option --chorousdepth.
.TP
.B "reverbdepth value"
Set default reverb depth.  The argument is identical with the option --reverbdepth.
.TP
.B "volume percent"
Total volume in percent unit (see \--volume option).
.TP
.B "drum channel"
Set drum a channel status.  Equivalent with \--drum option.
.TP
.B "drumflag bits"
Set drum channels.  The argument is a digit number indicating
drum channels (see --drumflag option).
.TP
.B "acceptall bool"
Accpet or disable all notes/sounds off events (see \--acceptall option).
.TP
.B "multipart bool"
Enable or suppress the multi MIDI part (see \--multipart option).
.TP
.B "tracks num"
Set track number of multi part (see \--tracks option).
.TP
.B "samecsec bool"
Enable or suppress the note off event check (see \--samecsec option).
.TP
.B "gsmacro bool"
Enable or suppress the GS part change check (see \--gsmacro option).
.TP
.B "xgmacro bool"
Enable or suppress the XG bank controls (see \--xgmacro option).
.TP
.B "xgmap bool"
Enable or suppress the XG SFX & drum mapping (see \--xgmap option).
.TP
.B "xgload fontfile"
Use the specified file for XG dynamic loading (see \--xgload option).
.TP
.B "subsf arguments.."
Load optional SoundFont file automatically.
The arguments are passed to sfxload(1) internally together with
"-x -b1" options.  For example, to load sfx.sf2 for sample.mid,
set "subsf sfx.sf2" in sample.id file.
.br
Note that this commmand will not work together with dynamic
loading.
.TP
.B "volscale scale"
Set volume scaling parameter (see \--volscale option).
.TP
.B "mt32 mode"
Set MT32 program mode.  The argument is from 0 to 2.
See \--mt32 option for each meaning.
.TP
.B "dynamic fontfile"
Use the specified font file for dynamic loading (see \--dynamic option).
.TP
.B "chnprior bool"
Enable or disable MIDI channel proprity mode
(see \--chnprior option).
.TP    
.B "chnvolume channel scale"
Set volume scale for each specified channel.  The scale factor
is given as same way as in volscale command.
.TP
.B "offset value"
Change the base key.  The argument is an integer number.
If the number -1 is given, all notes (except drums) will be
played in one semitone lower, and if 12 is given, the sounds
become one octave higher than normal output.
.TP
.B "newvolume bool"
Equivalent with --newvolume option.
.TP
.B "usefx bool"
Enable or disable effect change controls.
Equivalent with --usefx option.
Note that this feature is still experimental.
.TP
.B "fx_* value"
Set effect change parameters.  See the corresponding command
line option.  Valid only when usefx option is enabled.

.SH "SYSTEM RESOURCE FILE"

You can set default option arguments in the system resource file.
There are two files loaded as default.
.in +1i
$HOME/.drvmidirc
.br
/etc/drvmidirc
.in -1i

The syntax is as follows:
.in +1i
default options..
.in -1i
The first argument is arbitrary so far, but should be "default" for
future extensions.  The remaining arguments are identical with command
line options described above.

The resource file can be changed via File/Edit Options menu in tkmidi(1).
Althogh drvmidi accepts both short and long options in the resource
file, tkmidi can edit only long options.

.SH "EVENT HANDLING"
As default, drvmidi once writes music events on a buffer for up to two
seconds forward, then sends them to the sequencer device.  This
prevents a pausing even when some heavy process (like garbage
collection in emacs) is working unlike the previous version (ver.0.4.0
or older).

Since the events are sent to the device asynchronously, the program
need to know the playing actual time by the other means. Then, drvmidi
checks the system timer to know the current time and update the status
like volume bars.  Also, sends an echo back event once per second to
the sequencer, and synchronize the internal timer when receiving the
signal from sequencer device.

It is known that on some FreeBSD systems this function doesn't work
correctly.  In such a case, try the option --autoskip (I have no idea
why this solves the bug).  Also, you should try to disable --seqecho
or --seqbuf option.

.SH "SUPPORTED MIDI CONTROLS"
.I #0
bank select (MSB)
.br
.I #1
modulation wheel
.br
.I #6
data entry (MSB)
.br
.I #7
main volume
.br
.I #10
panning position
.br
.I #11
expression volume
.br
.I #32
bank select (LSB)
.br
.I #38
data entry (LSB)
.br
.I #64
sustain
.br
.I #66
sostenuto
.br
.I #67
soft pedal (experimental)
.br
.I #71
hermonic content (XG only)
.br
.I #72
attack time (XG only)
.br
.I #73
release time (XG only)
.br
.I #74
brightness (XG only)
.br
.I #91
reverb effects send
.br
.I #93
chorus effects send
.br
.I #98
NRPN LSB
.br
.I #99
NRPN MSB
.br
.I #100
RPN LSB
.br
.I #101
RPN MSB
.br
.I #120
all sounds off
.br
.I #121
reset controllers
.br
.I #123
all notes off

.SH "SYSEX MACROS"
drvmidi accepts the following system exclusive messages.
.TP
.B GM on
F0 7E 7F 09 01 F7
.TP
.TP
.B GS reset
F0 41 10 42 12 40 00 00 00 cs F7
.TP
.B GS reverb mode
F0 41 10 42 12 40 01 30 XX 00 F7
.br
where XX denotes the reverb mode (from 0 to 7).
.TP       
.B GS chorus mode
F0 41 10 42 12 40 01 38 XX 00 F7
.br
again, XX denotes the chorus mode (from 0 to 7).
.TP
.B GS drum part change
F0 41 10 42 12 40 1X 15 YY ?? ?? F7
.br
where X denotes the channel and YY denotes a drum flag.
.TP
.TP
.B GS master volume
F0 41 10 42 12 40 00 04 XX cs F7
.br
where XX denotes the volume (from 0 to 7).
.TP
.B GS multi mode
F0 41 10 42 12 00 00 7F XX cs F7
.br
where XX=0: double module mode, XX=1: single module mode.
.TP
.B XG on
F0 43 10 4C 00 00 7E 00 F7
.P

.SH "RPN CONTROLS"
drvmidi accepts the following RPN controls.  The heading numbers
describe the MSB/LSB RPN values in hex.
.TP
.I 00/00
Pitch bend sensitivity (MSB/LSB).  1 semitone per 128.
.TP
.I 00/01
Fine tuning (MSB/LSB). in 100/8192 cent unit, and
no tuning when MSB/LSB=8192.
.TP
.I 00/02
Coarse tuning (MSB/LSB). 1 semitone per 128, and no
tuning when MSB/LSB=8192 .
.TP
.I 7F/7F
Lock-in.  values are ignored.

.SH "GS (SC88) NRPN Controls"
The following numbers describe both NRPN MSB/LSB values
for SC88 NRPN controls.
In these controls, only MSB value is used as data entry
(from 0 to 127).
The center value is 64 in the all values.
.TP
.I "1/8"
Vibrato rate
.TP
.I "1/9"
Vibrato depth
.TP
.I "1/10"
Vibrato delay
.TP
.I "1/32"
TVF cutoff
.TP
.I "1/33"
TVF resonance
.TP
.I "1/99"
EG attak time
.TP
.I "1/100"
EG decay time
.TP
.I "1/102"
EG release time


.SH "AWE32 NRPN Controls"
The following numbers describe NRPN MSB/LSB values
for the AWE32 specific NRPN controls.
In these controls, both MSB and LSB values are used as data entry.
The center value is 8192 in the all values.
.TP
.I "127/0"
LFO1 delay
.TP
.I "127/1"
LFO1 freq
.TP
.I "127/2"
LFO2 delay
.TP
.I "127/3"
LFO2 freq
.TP
.I "127/4"
EG1 delay
.TP
.I "127/5"
EG1 attack
.TP
.I "127/6"
EG1 hold
.TP
.I "127/7"
EG1 decay
.TP
.I "127/8"
EG1 sustain
.TP
.I "127/9"
EG1 release
.TP
.I "127/10"
EG2 delay
.TP
.I "127/11"
EG2 attack
.TP
.I "127/12"
EG2 hold
.TP
.I "127/13"
EG2 decay
.TP
.I "127/14"
EG2 sustain
.TP
.I "127/15"
EG2 release
.TP
.I "127/16"
initial pitch
.TP
.I "127/17"
LFO1 pitch
.TP
.I "127/18"
LFO2 pitch
.TP
.I "127/19"
EG1 pitch
.TP
.I "127/20"
LFO1 volume
.TP
.I "127/21"
Cutoff
.TP
.I "127/22"
Resonance
.TP
.I "127/23"
LFO1 cutoff
.TP
.I "127/24"
EG1 cutoff
.TP
.I "127/25"
chorus
.TP
.I "127/26"
reverb

.SH "SEE ALSO"
tkmidi(1), sfxload(1), setfx(1).

.SH COPYRIGHT
Copyright (C) 1996-1998 Takashi Iwai.
.P
The AWE32 driver and utilities are free software; you can redistribute them
and/or modify them under the terms of the \fIGNU General Public
License\fP as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
