/*
 * signal handler
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

typedef struct HandlerList {
	void (*handler)();
	struct HandlerList *next;
} HandlerList;

static HandlerList *hlist[NSIG];

void call_handlers(int sig)
{
	HandlerList *p;
	for (p = hlist[sig]; p; p = p->next)
		p->handler(sig);
}

void exit_handlers(int sig)
{
	call_handlers(sig);
	exit(0);
}

void add_signal(int sig, void (*handler)(), int exit_after)
{
	HandlerList *rec = (HandlerList*)malloc(sizeof(HandlerList));
	if (rec == NULL) {
		fprintf(stderr, "can't malloc handler\n");
		exit(1);
	}
	rec->handler = handler;
	rec->next = hlist[sig];
	hlist[sig] = rec;
	if (exit_after)
		signal(sig, exit_handlers);
	else
		signal(sig, call_handlers);
}

void reset_signal(int sig)
{
	signal(sig, call_handlers);
}
