/*
 * Codec "patch" interface
 *
 * Copyright (C) 2007 Takashi Iwai
 * 
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 */

#ifndef __HDA_PATCH_H_INC
#define __HDA_PATCH_H_INC

struct hda_codec_table {
	unsigned int id;
	unsigned int revs;
	unsigned int num_presets;
	const char **presets;
	const char *vendor_name;
	const char *name;
	int (*patch)(const struct hda_codec_table *tbl, int config,
		     const char **args);
};

#define HDA_PATCH_DESC	"patch_descriptor"
/* each object has to contain the function "patch_descriptor"
 * of the type below
 */
typedef const struct hda_codec_table *(*hda_patch_desc_t)(void);


#endif /* __HDA_PATCH_H_INC */
