#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "hda/cmds.h"
#include "hda/io.h"
#include "hda/mixer.h"

static struct hda_cmds uniwill_hp_automute =
	STD_JACK_SENSE(0x14,
		       STD_CMD_LIST(STD_STEREO_MUTE(0x15, HDA_AC_OUT),
				    STD_STEREO_MUTE(0x16, HDA_AC_OUT),
				    STD_NULL),
		       STD_CMD_LIST(STD_STEREO_UNMUTE(0x15, HDA_AC_OUT),
				    STD_STEREO_UNMUTE(0x16, HDA_AC_OUT),
				    STD_NULL));


struct hda_cmds uniwill_mic_automute = 
	STD_JACK_SENSE(0x18,
		       STD_CMD_LIST(STD_STEREO_UNMUTE(0x0b, HDA_AC_IN(1)),
				    STD_NOTIFY("Front Mic Playback Switch")),
		       STD_CMD_LIST(STD_STEREO_MUTE(0x0b, HDA_AC_IN(1)),
				    STD_NOTIFY("Front Mic Playback Switch")));

struct hda_verb verbs[] = {
	{0x01, 0x123, 0x04},
	{0x02, 0x432, 0x01},
	{0x03, 0xfff, 0xff},
	{ }
};

struct hda_cmds verbs_cmds = {
	.type = HDA_CMD_TYPE_VERBS,
	.val = (long) verbs,
};

static void detlv(struct hda_tlv *tlv)
{
	hda_tlv_dump(tlv, stdout);
	printf("\n");
}

static void dump_tlv(struct hda_tlv *tlv)
{
	unsigned char *p;
	int i;

	p = (unsigned char *)tlv;
	for (i = 0; i < tlv->len + 4; i++) {
		printf(" %02x", p[i]);
		if (i % 16 == 15)
			printf("\n");
	}
	if (i % 16)
		printf("\n");
	printf("\n");
}

int main(int argc, char **argv)
{
	struct hda_tlv *tlv;

	tlv = hda_cmd_to_tlv(&uniwill_hp_automute);
	printf("uniwill_hp_automute\n");
	dump_tlv(tlv);
	if (argc > 1)
		detlv(tlv);
	hda_free_tlv(tlv);

	tlv = hda_cmd_to_tlv(&uniwill_mic_automute);
	printf("uniwill_mic_automute\n");
	dump_tlv(tlv);
	if (argc > 1)
		detlv(tlv);
	hda_free_tlv(tlv);

	tlv = hda_verbs_to_tlv(verbs);
	printf("verbs\n");
	dump_tlv(tlv);
	if (argc > 1)
		detlv(tlv);
	hda_free_tlv(tlv);

	tlv = hda_cmd_to_tlv(&verbs_cmds);
	printf("verbs_cmds\n");
	dump_tlv(tlv);
	if (argc > 1)
		detlv(tlv);
	hda_free_tlv(tlv);

	return 0;
}

/* override */
unsigned int hda_look_for_ctl_id(const char *name)
{
	return 1;
}
